unit CustomProgressBar;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls,StdCtrls;

type
  TCustomProgressBar = class(TProgressBar)
  private
     Label1:TLabel;

     procedure SetCaption(Cap:string);
     function GetCaption:string;
     procedure SetFont(Fnt:TFont);
     function GetFont:TFont;
  protected
  public
     constructor Create(AOwner:TComponent);override;
     destructor Destroy;override;
  published
     property Caption:string read GetCaption
                            write SetCaption;
     property Font:TFont read GetFont write SetFont;
  end;

procedure Register;

implementation

constructor TCustomProgressBar.Create(AOwner:TComponent);
begin
   inherited Create(AOwner);

   Label1:=TLabel.Create(Self);
   Label1.Parent:=Self;

   Label1.Left:=0;
   Label1.Top:=0;
   Label1.Transparent:=True;
   Label1.Visible:=True;
   Label1.Enabled:=True;

   //Font:=TFont.Create;

   Smooth:=True;
end;

destructor TCustomProgressBar.Destroy;
begin
   //Font.Free;
   Label1.Free;

   inherited Destroy;
end;

procedure TCustomProgressBar.SetCaption(Cap:string);
begin
   Label1.Caption:=Cap;
end;

function TCustomProgressBar.GetCaption:string;
begin
   Result:=Label1.Caption;
end;

procedure TCustomProgressBar.SetFont(Fnt:TFont);
begin
   Label1.Font:=Fnt;
end;

function TCustomProgressBar.GetFont:TFont;
begin
   Result:=Label1.Font;
end;
      
procedure Register;
begin
  RegisterComponents('Game Components', [TCustomProgressBar]);
end;

end.
