unit PrivateComboBox;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TPrivateComboBox = class(TComboBox)
    private
      FOutlineColor:TColor;
      FOnMeasureItem:TDrawItemEvent;
                              
      procedure ComboBoxOnDrawItem(Control:TWinControl;
                                   Index:Integer;
                                   Rect:TRect;
                                   State:TOwnerDrawState);
    protected
      procedure WMPaint(var Message: TWMPaint); message WM_PAINT;
    public
      constructor Create(AOwner:TComponent);override;

    published
      property OutlineColor:TColor read FOutlineColor write FOutlineColor;
      property OnDrawItem:TDrawItemEvent read FOnMeasureItem write FOnMeasureItem;
  end;

procedure Register;

implementation

constructor TPrivateComboBox.Create(AOwner:TComponent);
begin
  inherited Create(AOwner);

  Style:=csOwnerDrawVariable;

  Color:=clBlack;
  OutlineColor:=$00FFAF0F;

  inherited OnDrawItem:=ComboBoxOnDrawItem;
end;
         {
procedure TPrivateComboBox.WMPaint(var Message: TWMPaint);
var PS:TPaintStruct;
    DC:HDC;
    Pen,PrevPen:HPEN;
    Brush,PrevBrush:HBRUSH;
    lb:LOGBRUSH;
    Bitmap:TBitmap;
    Points:array of TPoint;
begin
  Pen:=CreatePen(PS_SOLID,0,OutlineColor);

  lb.lbStyle:=BS_SOLID;
  lb.lbColor:=Color;
  Brush:=CreateBrushIndirect(lb);

  DC:=BeginPaint(Handle,PS);

  PrevPen:=SelectObject(DC,Pen);
  PrevBrush:=SelectObject(DC,Brush);

  Rectangle(DC,0,0,Width,Height);

 // if ItemIndex >= 0 then
//  begin
 //   SelectObject(DC,Font.Handle);
  //  TextOut(DC,5,TextExtent(

  Bitmap:=TBitmap.Create;
  Bitmap.Width:=ItemHeight;    //  quad so Height both
  Bitmap.Height:=ItemHeight;
  Bitmap.PixelFormat:=pf24bit;

  Bitmap.Canvas.Brush.Color:=Color;
  Bitmap.Canvas.Pen.Color:=OutlineColor;

  Bitmap.Canvas.Rectangle(0,0,Bitmap.Width,Bitmap.Height);

  SetLength(Points,3);
  Points[0].x:=Round(Bitmap.Width/2);
  Points[0].y:=2*Round(Bitmap.Height/3);
  Points[1].x:=Points[0].x-Round(Points[0].x/2);
  Points[1].y:=Points[0].y-Round(Points[0].x/2);
  Points[2].x:=Points[0].x+Round(Points[0].x/2);
  Points[2].y:=Points[0].y-Round(Points[0].x/2);

  Bitmap.Canvas.Polygon(Points);

  BitBlt(DC,
         Width-Height+Round((Height-ItemHeight)/2)+1,
         Round((Height-ItemHeight)/2),
         Bitmap.Width,
         Bitmap.Height,
         Bitmap.Canvas.Handle,
         0,
         0,
         SRCCOPY);

  SelectObject(DC,PrevPen);
  SelectObject(DC,PrevBrush);

  DeleteObject(Pen);
  DeleteObject(Brush);

  EndPaint(Handle,PS);
end;       }

procedure TPrivateComboBox.WMPaint(var Message: TWMPaint);
var Canvas:TCanvas;
    PS:TPaintStruct;
    Bitmap:TBitmap;
    Points:array of TPoint;
begin

  Canvas:=TControlCanvas.Create;
  Canvas.Handle:=BeginPaint(Handle,PS);

  Canvas.Pen.Color:=OutlineColor;
  Canvas.Brush.Color:=Color;

  Canvas.Rectangle(0,0,Width,Height);

  if ItemIndex >= 0 then
  begin
    Canvas.Font:=Font;
                     
    with Canvas do
    TextOut(5,
            Round((Height-TextExtent(Items.Strings[ItemIndex]).cy)/2),
            Items.Strings[ItemIndex]);
  end;

  Bitmap:=TBitmap.Create;
  Bitmap.Width:=ItemHeight;    //  quad so Height both
  Bitmap.Height:=ItemHeight;
  Bitmap.PixelFormat:=pf24bit;

  Bitmap.Canvas.Brush.Color:=Color;
  Bitmap.Canvas.Pen.Color:=OutlineColor;

  Bitmap.Canvas.Rectangle(0,0,Bitmap.Width,Bitmap.Height);

  SetLength(Points,3);
  Points[0].x:=Round(Bitmap.Width/2);
  Points[0].y:=2*Round(Bitmap.Height/3);
  Points[1].x:=Points[0].x-Round(Points[0].x/2);
  Points[1].y:=Points[0].y-Round(Points[0].x/2);
  Points[2].x:=Points[0].x+Round(Points[0].x/2);
  Points[2].y:=Points[0].y-Round(Points[0].x/2);

  Bitmap.Canvas.Polygon(Points);

  BitBlt(Canvas.Handle,
         Width-Height+Round((Height-ItemHeight)/2)+1,
         Round((Height-ItemHeight)/2),
         Bitmap.Width,
         Bitmap.Height,
         Bitmap.Canvas.Handle,
         0,
         0,
         SRCCOPY);

  EndPaint(Handle,PS);

  Canvas.Free;
end;

procedure TPrivateComboBox.ComboBoxOnDrawItem(Control:TWinControl;
                                              Index:Integer;
                                              Rect:TRect;
                                              State:TOwnerDrawState);
begin

  Canvas.Brush.Color:=Color;
  Canvas.Pen.Color:=Color;

  Canvas.Rectangle(Rect);

  Canvas.Font:=Font;

  with Canvas do
  TextOut(5,
          Rect.Top+Round(((Rect.Bottom-Rect.Top)-TextExtent(Items.Strings[Index]).cy)/2)-1,
          Items.Strings[Index]);


  if Assigned(OnDrawItem) then OnDrawItem(Control,Index,Rect,State);

end;


procedure Register;
begin
  RegisterComponents('Game Components', [TPrivateComboBox]);
end;

end.
