unit PrivateGroupBox;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls,StdCtrls;

type
  TPrivateGroupBox = class(TPanel)
    private
      FCaption:TCaption;
      FCaptionHeight:integer;
      FCaptionUnderline:boolean;
      FOutlineColor:TColor;

      procedure SetCaption(NewCaption:TCaption);
      procedure SetCaptionHeight(NewHeight:integer);
      procedure SetCaptionUnderline(NewValue:boolean);
      procedure SetOutlineColor(NewColor:TColor);

    protected
      procedure Paint;override;

    public

      constructor Create(AOwner:TComponent);override;
      destructor Destroy;override;

    published
      property Caption:TCaption read FCaption write SetCaption;
      property CaptionHeight:integer read FCaptionHeight write SetCaptionHeight;
      property CaptionUnderline:boolean read FCaptionUnderline write SetCaptionUnderline;
      property OutlineColor:TColor read FOutlineColor write SetOutlineColor;
  end;

procedure Register;

implementation

constructor TPrivateGroupBox.Create(AOwner:TComponent);
begin
  inherited Create(AOwner);

  FCaptionHeight:=20;
end;

destructor TPrivateGroupBox.Destroy;
begin

  inherited Destroy;
end;

procedure TPrivateGroupBox.SetCaption(NewCaption:TCaption);
begin
  inherited Caption:='';

  FCaption:=NewCaption;

  Repaint;
end;

procedure TPrivateGroupBox.SetCaptionHeight(NewHeight:integer);
begin
  FCaptionHeight:=NewHeight;

  Repaint;
end;

procedure TPrivateGroupBox.SetCaptionUnderline(NewValue:boolean);
begin
  FCaptionUnderline:=NewValue;

  Repaint;
end;

procedure TPrivateGroupBox.SetOutlineColor(NewColor:TColor);
begin
  FOutlineColor:=NewColor;

  Repaint;
end;

procedure TPrivateGroupBox.Paint;
var Canvas:TCanvas;
begin
  inherited Paint;

  Canvas:=TControlCanvas.Create;
  Canvas.Handle:=GetDC(Handle);

  Canvas.Pen.Color:=OutlineColor;
  Canvas.Brush.Color:=Color;

  Canvas.Rectangle(0,0,Width,Height);

  if CaptionUnderline then
  begin
    Canvas.MoveTo(0,CaptionHeight);
    Canvas.LineTo(Width,CaptionHeight);
  end;

  Canvas.Font:=Font;

  with Canvas do
  TextOut(5,Round((CaptionHeight-TextExtent(Caption).cy)/2),Caption);

  Canvas.Free;

end;






procedure Register;
begin
  RegisterComponents('Game Components', [TPrivateGroupBox]);
end;

end.