unit PrivateListBox;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TPrivateListBox = class(TListBox)
    private
      FSelItemTextColor:TColor;
      FTextBackgroundColor:TColor;

      FOnMouseDown:TMouseEvent;
      FOnDrawItem:TDrawItemEvent;

      procedure SetSelItemTextColor(NewColor:TColor);
      procedure SetTextBackgroundColor(NewColor:TColor);

      procedure ListBoxOnMouseDown(Sender:TObject;
                                   Button:TMouseButton;
                                   Shift:TShiftState;
                                   X,Y:Integer);
      procedure ListBoxOnDrawItem(Control:TWinControl;
                                  Index:Integer;
                                  Rect:TRect;
                                  State:TOwnerDrawState);

      procedure WMPaint(var Message: TWMPaint); message WM_PAINT;
    protected
    public
      constructor Create(AOwner:TComponent);override;
    published
      property SelItemTextColor:TColor read FSelItemTextColor write SetSelItemTextColor;
      property TextBackgroundColor:TColor read FTextBackgroundColor write SetTextBackgroundColor;
      property OnMouseDown:TMouseEvent read FOnMouseDown write FOnMouseDown;
      property OnDrawItem:TDrawItemEvent read FOnDrawItem write FOnDrawItem;
  end;

procedure Register;

implementation

constructor TPrivateListBox.Create(AOwner:TComponent);
begin
  inherited Create(AOwner);

  BorderStyle:=bsNone;

  inherited OnMouseDown:=ListBoxOnMouseDown;

  inherited OnDrawItem:=ListBoxOnDrawItem;

  Style:=lbOwnerDrawVariable;
end;

procedure TPrivateListBox.WMPaint(var Message: TWMPaint);
var Canvas:TCanvas;
    PS:TPaintStruct;
begin
  inherited;

  Canvas:=TControlCanvas.Create;
  Canvas.Handle:=BeginPaint(Handle,PS);

  Canvas.Rectangle(0,0,20,20);

  EndPaint(Handle,PS);

  Canvas.Free;
end;

procedure TPrivateListBox.SetSelItemTextColor(NewColor:TColor);
begin
  FSelItemTextColor:=NewColor;

  Repaint;
end;

procedure TPrivateListBox.SetTextBackgroundColor(NewColor:TColor);
begin
  FTextBackgroundColor:=NewColor;

  Repaint;
end;

procedure TPrivateListBox.ListBoxOnMouseDown(Sender:TObject;
                                             Button:TMouseButton;
                                             Shift:TShiftState;
                                             X,Y:Integer);
begin               
  Repaint;

  if Assigned(OnMouseDown) then OnMouseDown(Sender,Button,Shift,X,Y);
end;

procedure TPrivateListBox.ListBoxOnDrawItem(Control:TWinControl;
                                            Index:Integer;
                                            Rect:TRect;
                                            State:TOwnerDrawState);
begin
  Color:=TextBackgroundColor;

  Canvas.Pen.Color:=TextBackgroundColor;
  Canvas.Brush.Color:=TextBackgroundColor;
                               {
  if ItemIndex = Index then
  Canvas.Brush.Color:=clRed
  else
  Canvas.Brush.Color:=TextBackgroundColor; }

  Canvas.Rectangle(Rect);

  Canvas.Font:=Font;

  if ItemIndex = Index then
  Canvas.Font.Color:=SelItemTextColor;


  with Canvas do
  TextOut(Rect.Left,Rect.Top+Round(((Rect.Bottom-Rect.Top)-TextExtent(Items.Strings[Index]).cy)/2)-1,Items.Strings[Index]);


  if Assigned(OnDrawItem) then OnDrawItem(Control,Index,Rect,State);
end;






procedure Register;
begin
  RegisterComponents('Game Components', [TPrivateListBox]);
end;

end.
