unit PrivateTabCtrl;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls;

type

  TBookMarkPanel = class(TPanel)
    private
      FOutlineColor:TColor;
      procedure SetOutlineColor(NewColor:TColor);

      procedure PaintOutline;
    protected
      procedure Paint;override;
    published
      property OutlineColor:TColor read FOutlineColor write SetOutlineColor;
  end;

  TPrivateTabCtrl = class(TPanel)
    private
      FTabs:TStrings;
      FTabIndex:integer;
      FTabHeight:integer;
      FActiveTabColor:TColor;
      FInActiveTabColor:TColor;
      FOutlineColor:TColor;

      FOnChange:TNotifyEvent;

      TabPanels:array of TBookMarkPanel;

      procedure SetTabs(NewTabs:TStrings);
      procedure SetTabIndex(NewIndex:integer);
      procedure SetTabHeight(NewHeight:integer);
      procedure SetActiveTabColor(NewColor:TColor);
      procedure SetInActiveTabColor(NewColor:TColor);
      procedure SetOutlineColor(NewColor:TColor);


      procedure StringsOnChange(Sender:TObject);
      procedure PanelOnMouseDown(Sender:TObject;
                                 Button:TMouseButton;
                                 Shift:TShiftState;
                                 X,Y:Integer);

      procedure PaintOutline;
    protected
      procedure Paint;override;
      procedure Resize;override;
    public

      constructor Create(AOwner:TComponent);override;
      destructor Destroy;override;

      procedure UpdateTabs;

    published
      property Tabs:TStrings read FTabs write SetTabs;
      property TabIndex:integer read FTabIndex write SetTabIndex;
      property TabHeight:integer read FTabHeight write SetTabHeight;
      property ActiveTabColor:TColor read FActiveTabColor write SetActiveTabColor;
      property InActiveTabColor:TColor read FInActiveTabColor write SetInActiveTabColor;
      property OutlineColor:TColor read FOutlineColor write SetOutlineColor;

      property OnChange:TNotifyEvent read FOnChange write FOnChange;
  end;

procedure Register;

implementation

//******  TBookMarkPanel  ************************************************************

procedure TBookMarkPanel.SetOutlineColor(NewColor:TColor);
begin
  FOutlineColor:=NewColor;

  PaintOutline;
end;

procedure TBookMarkPanel.Paint;
begin
  inherited Paint;

  PaintOutline;
end;

procedure TBookMarkPanel.PaintOutline;
var Canvas:TCanvas;
    Points:array of TPoint;
begin
  Canvas:=TControlCanvas.Create;

  Canvas.Handle:=GetDC(Handle);

  SetLength(Points,4);

  Points[0].x:=0;
  Points[0].y:=Height;
  Points[1].x:=0;
  Points[1].y:=0;
  Points[2].x:=Width;
  Points[2].y:=0;
  Points[3].x:=Width;
  Points[3].y:=Height;

  Canvas.Pen.Color:=OutlineColor;

  Canvas.Polyline(Points);

  Canvas.Free;
end;





//******  TPrivateTabCtrl  ***********************************************************

constructor TPrivateTabCtrl.Create(AOwner:TComponent);
begin
  inherited Create(AOwner);

  BevelInner:=bvNone;
  BevelOuter:=bvNone;

  FTabs:=TStringList.Create;
  TStringList(FTabs).OnChange:=StringsOnChange;

  SetTabHeight(20);

  SetActiveTabColor(clBlack);
  SetInActiveTabColor($007F5F1F);
  SetOutlineColor($00FFAF0F);

  Font.Color:=OutlineColor;
end;

destructor TPrivateTabCtrl.Destroy;
var C1:integer;
begin
  for C1:=0 to High(TabPanels) do
  TabPanels[C1].Free;

  SetLength(TabPanels,0);

  inherited Destroy;
end;

procedure TPrivateTabCtrl.SetTabs(NewTabs:TStrings);
begin
  FTabs.Assign(NewTabs);

  UpdateTabs;
end;

procedure TPrivateTabCtrl.SetTabIndex(NewIndex:integer);
var C1:integer;
begin
  FTabIndex:=NewIndex;

  for C1:=0 to High(TabPanels) do
  begin
    if C1 = NewIndex then
    TabPanels[C1].Color:=ActiveTabColor
    else
    TabPanels[C1].Color:=InActiveTabColor;
  end;

  PaintOutline;
end;

procedure TPrivateTabCtrl.SetTabHeight(NewHeight:integer);
var C1:integer;
begin
  FTabHeight:=NewHeight;

  for C1:=0 to High(TabPanels) do
  TabPanels[C1].Height:=NewHeight;
end;

procedure TPrivateTabCtrl.SetActiveTabColor(NewColor:TColor);
begin                           
  FActiveTabColor:=NewColor;

  Color:=NewColor;

  PaintOutline;
end;

procedure TPrivateTabCtrl.SetInActiveTabColor(NewColor:TColor);
begin
  FInActiveTabColor:=NewColor;

  PaintOutline;
end;

procedure TPrivateTabCtrl.SetOutlineColor(NewColor:TColor);
var C1:integer;
begin
  FOutlineColor:=NewColor;

  for C1:=0 to High(TabPanels) do
  TabPanels[C1].OutlineColor:=NewColor;

  PaintOutline;
end;

procedure TPrivateTabCtrl.StringsOnChange(Sender:TObject);
begin                               
  UpdateTabs;
end;


procedure TPrivateTabCtrl.Paint;
begin
  inherited Paint;

  PaintOutline;
end;

procedure TPrivateTabCtrl.Resize;
begin
  inherited Resize;

  if Length(TabPanels) > 0 then
  UpdateTabs;
end;             

procedure TPrivateTabCtrl.UpdateTabs;
var TabWidth:integer;
    C1:integer;
begin
  for C1:=0 to High(TabPanels) do
  TabPanels[C1].Free;

  SetLength(TabPanels,Tabs.Count);

  TabWidth:=Round(Width/Tabs.Count);

  for C1:=0 to Tabs.Count-1 do
  begin
    TabPanels[C1]:=TBookMarkPanel.Create(Self);
    TabPanels[C1].Parent:=Self;
    TabPanels[C1].Left:=C1*TabWidth;
    TabPanels[C1].Top:=0;
    TabPanels[C1].Width:=TabWidth;
    TabPanels[C1].Height:=TabHeight;
    TabPanels[C1].Caption:=Tabs.Strings[C1];
    TabPanels[C1].BevelInner:=bvNone;
    TabPanels[C1].BevelOuter:=bvNone;
    TabPanels[C1].ParentFont:=True;
    TabPanels[C1].OutlineColor:=OutlineColor;
    TabPanels[C1].Tag:=C1;
    TabPanels[C1].OnMouseDown:=PanelOnMouseDown;
    TabPanels[C1].Visible:=True;
  end;

  if Length(TabPanels) > 0 then
  SetTabIndex(0)
  else
  SetTabIndex(-1);

                      {

  for C1:=0 to High(TabPanels) do
  ShowMessage(TabPanels[C1].Caption+' '+IntToStr(TabPanels[C1].Left)+' '+IntToStr(TabPanels[C1].Top)+' Owner:'+Owner.ClassName+' Parent:'+TPanel(Parent).Caption);
  ShowMessage(IntToStr(Length(TabPanels)));  }   


end;

procedure TPrivateTabCtrl.PanelOnMouseDown(Sender:TObject;
                                           Button:TMouseButton;
                                           Shift:TShiftState;
                                           X,Y:Integer);
begin
  SetTabIndex(TPanel(Sender).Tag);

  if Assigned(OnChange) then OnChange(Self); 
end;





procedure TPrivateTabCtrl.PaintOutline;
var Canvas:TCanvas;
    Points:array of TPoint;
begin
  Canvas:=TControlCanvas.Create;
  Canvas.Handle:=GetDC(Handle);




  if Length(TabPanels) > 0 then
  begin
    SetLength(Points,6);

    Points[0].x:=TabPanels[TabIndex].Left;
    Points[0].y:=TabHeight;
    Points[1].x:=0;
    Points[1].y:=TabHeight;
    Points[2].x:=0;
    Points[2].y:=Height-1;
    Points[3].x:=Width-1;
    Points[3].y:=Height-1;
    Points[4].x:=Width-1;
    Points[4].y:=TabHeight;
    Points[5].x:=TabPanels[TabIndex].Left+TabPanels[TabIndex].Width-1;
    Points[5].y:=TabHeight;


    Canvas.Pen.Color:=Color;
    Canvas.MoveTo(Points[0].x,Points[0].y);
    Canvas.LineTo(Points[5].x,Points[5].y);
    Canvas.Pixels[Points[5].x,Points[5].y]:=Color;
  end
  else
  begin
    SetLength(Points,5);

    Points[0].x:=0;
    Points[0].y:=0;
    Points[1].x:=0;
    Points[1].y:=Height-1;
    Points[2].x:=Width-1;
    Points[2].y:=Height-1;
    Points[3].x:=Width-1;
    Points[3].y:=0;
    Points[4].x:=0;
    Points[4].y:=0;
  end;

  Canvas.Pen.Color:=OutlineColor;

  Canvas.Polyline(Points);

  Canvas.MoveTo(Width-1,0);
  Canvas.LineTo(Width-1,TabHeight);

  Canvas.Free;

end;









procedure Register;
begin
  RegisterComponents('Game Components', [TPrivateTabCtrl]);
end;

end.
