#include "stdafx.h"
#include "D3D9TestAppDoc.h"
#include "D3D9TestApp.h"
#include "D3D9TestAppView.h"
#include <mmsystem.h>

IMPLEMENT_DYNCREATE(CD3D9TestAppView, CView)

BEGIN_MESSAGE_MAP(CD3D9TestAppView, CView)
	//{{AFX_MSG_MAP(CD3D9TestAppView)
	ON_WM_TIMER()
	ON_WM_MOUSEMOVE()
	ON_WM_CREATE()
	ON_WM_DESTROY()
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CView::OnFilePrintPreview)
END_MESSAGE_MAP()

CD3D9TestAppView::CD3D9TestAppView()
{
  m_piDirect3D9 = NULL;
  m_piDirect3DDevice9 = NULL;
}

CD3D9TestAppView::~CD3D9TestAppView()
{
}

BOOL CD3D9TestAppView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CD3D9TestAppView drawing

void CD3D9TestAppView::OnDraw(CDC* pDC)
{
	CD3D9TestAppDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	// TODO: add draw code for native data here

}

/////////////////////////////////////////////////////////////////////////////
// CD3D9TestAppView printing

BOOL CD3D9TestAppView::OnPreparePrinting(CPrintInfo* pInfo)
{
	// default preparation
	return DoPreparePrinting(pInfo);
}

void CD3D9TestAppView::OnBeginPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add extra initialization before printing
}

void CD3D9TestAppView::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add cleanup after printing
}

/////////////////////////////////////////////////////////////////////////////
// CD3D9TestAppView diagnostics

void CD3D9TestAppView::AssertValid() const
{
	CView::AssertValid();
}

void CD3D9TestAppView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CD3D9TestAppDoc* CD3D9TestAppView::GetDocument()
{
  ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CD3D9TestAppDoc)));
	return (CD3D9TestAppDoc*)m_pDocument;
}

/////////////////////////////////////////////////////////////////////////////
// CD3D9TestAppView message handlers

int CD3D9TestAppView::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CView::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	// TODO: Add your specialized creation code here

  timeBeginPeriod(1);

  SetTimer(0,50,NULL);
	
	return 0;
}

void CD3D9TestAppView::OnDestroy() 
{
	CView::OnDestroy();
	
	// TODO: Add your message handler code here
	
  timeEndPeriod(1);
}


typedef struct tagVERTEX
{
  float x;
  float y;
  float z;
  DWORD color;
  float u;
  float v;
} VERTEX;

D3DVIEWPORT9 vp;

void CD3D9TestAppView::InitializeDirect3D()
{
  char pCurrentDir[MAX_PATH];
  GetModuleFileName(NULL,pCurrentDir,MAX_PATH-1);

  int len = strlen(pCurrentDir);

  for (int i = len-1;i >= 0;i--)
  {
    if (pCurrentDir[i] == '\\')
    {
      pCurrentDir[i] = '\0';
      break;
    }
  }

  SetCurrentDirectory(pCurrentDir);

  m_piDirect3D9 = Direct3DCreate9(D3D_SDK_VERSION);



  if (m_piDirect3DDevice9)
    return;

  D3DPRESENT_PARAMETERS params;
  params.BackBufferWidth = 0;
  params.BackBufferHeight = 0;
  params.BackBufferFormat = D3DFMT_A8R8G8B8;
  params.BackBufferCount = 1;
  params.MultiSampleType = D3DMULTISAMPLE_NONE;
  params.MultiSampleQuality = 0;
  params.SwapEffect = D3DSWAPEFFECT_COPY;
  params.hDeviceWindow = m_hWnd;
  params.Windowed = TRUE;
  params.EnableAutoDepthStencil = TRUE;
  params.AutoDepthStencilFormat = D3DFMT_D16;
  params.Flags = D3DPRESENTFLAG_DEVICECLIP;
  params.FullScreen_RefreshRateInHz = D3DPRESENT_RATE_DEFAULT;
  params.PresentationInterval = D3DPRESENT_INTERVAL_DEFAULT;

  if (!m_piDirect3DDevice9)
    m_piDirect3D9->CreateDevice(D3DADAPTER_DEFAULT,
                                D3DDEVTYPE_HAL,
                                m_hWnd,
                                D3DCREATE_HARDWARE_VERTEXPROCESSING,
                                &params,
                                &m_piDirect3DDevice9);

  FILE* pFile = fopen("Blocks.jpg","rb");

  if (!pFile)
  {
    MessageBox("Cannot open \"Blocks.jpg\".");
    return;
  }

  fseek(pFile,0,SEEK_END);

  int iSize = ftell(pFile);

  fseek(pFile,0,SEEK_SET);

  DWORD* pData = new DWORD[iSize];

  fread(pData,iSize,1,pFile);

  fclose(pFile);

  

  D3DXCreateTextureFromFileInMemory(m_piDirect3DDevice9,pData,iSize,&m_piTexture);

  delete [] pData;



  RECT rect;
  GetClientRect(&rect);

  vp.X = 0;
  vp.Y = 0;
  vp.Width = rect.right;
  vp.Height = rect.bottom;
  vp.MinZ = 0;
  vp.MaxZ = 1;
  m_piDirect3DDevice9->SetViewport(&vp);



  D3DXCreateMatrixStack(0,&m_piViewStack);
  D3DXCreateMatrixStack(0,&m_piProjectionStack);

  D3DXMATRIX xm;
  D3DXMatrixOrthoRH(&xm,2,2,-1,1);

  m_piViewStack->LoadIdentity();
  m_piProjectionStack->LoadMatrix(&xm);



  m_piDirect3DDevice9->SetTransform(D3DTS_VIEW,m_piViewStack->GetTop());
  m_piDirect3DDevice9->SetTransform(D3DTS_PROJECTION,m_piProjectionStack->GetTop());

  m_piDirect3DDevice9->SetRenderState(D3DRS_CULLMODE,D3DCULL_NONE);



  m_fAngle = 0;
}

typedef struct tagVX
{
  float x;
  float y;
  float z;
  COLORREF color;
} VX;

VERTEX q[4] = { -0.1f, -0.1f, 0, 0xFFFFFFFF, 0, 0,
                 0.1f, -0.1f, 0, 0xFFFFFFFF, 0, 0,
                -0.1f,  0.1f, 0, 0xFFFFFFFF, 0, 0,
                 0.1f,  0.1f, 0, 0xFFFFFFFF, 0, 0 };

float q_x = 0,q_y = 0;

#define PI 3.1415

void CD3D9TestAppView::OnTimer(UINT nIDEvent) 
{
	// TODO: Add your message handler code here and/or call default

  if (!m_piDirect3DDevice9)
    InitializeDirect3D();

  VERTEX quad[4];

  

  m_piDirect3DDevice9->SetFVF(D3DFVF_XYZ | D3DFVF_DIFFUSE | D3DFVF_TEX2);

  m_piDirect3DDevice9->Clear(0,NULL,D3DCLEAR_TARGET | D3DCLEAR_ZBUFFER,0xFF00FF00,1,0);



  m_piDirect3DDevice9->SetRenderState(D3DRS_FILLMODE,D3DFILL_SOLID);
  m_piDirect3DDevice9->SetRenderState(D3DRS_SHADEMODE,D3DSHADE_FLAT);
  m_piDirect3DDevice9->SetRenderState(D3DRS_COLORVERTEX,TRUE);
  m_piDirect3DDevice9->SetRenderState(D3DRS_DIFFUSEMATERIALSOURCE,D3DMCS_COLOR1);

  m_piDirect3DDevice9->SetRenderState(D3DRS_COLORVERTEX,TRUE);
  m_piDirect3DDevice9->SetRenderState(D3DRS_DITHERENABLE,FALSE);
  m_piDirect3DDevice9->SetRenderState(D3DRS_SPECULARENABLE,FALSE);
  m_piDirect3DDevice9->SetRenderState(D3DRS_AMBIENT,0xFFFFFFFF);
  m_piDirect3DDevice9->SetRenderState(D3DRS_AMBIENTMATERIALSOURCE,D3DMCS_COLOR1);



  m_piViewStack->Push();
  m_piProjectionStack->Push();

  

  D3DXMATRIX frustum_m;
  //D3DXMatrixPerspectiveOffCenterRH(&frutum_m,-0.001f,0.001f,-0.001f,0.001f,0.001f,10);

  D3DXMatrixPerspectiveRH(&frustum_m,0.002f,0.002f,0.001f,10);

  m_piProjectionStack->MultMatrixLocal(&frustum_m);



  D3DXMATRIX camera_m;
  D3DXMatrixTranslation(&camera_m,0,0,-1);

  m_piProjectionStack->MultMatrixLocal(&camera_m);
  


  m_piDirect3DDevice9->SetTransform(D3DTS_PROJECTION,m_piProjectionStack->GetTop());



  quad[0].x = -1.1f;
  quad[0].y = 0;
  quad[0].z = 0;
  quad[0].u = 0;
  quad[0].v = 1;
  quad[0].color = 0xFFF00FFF;

  quad[1].x = 0;
  quad[1].y = 1;
  quad[1].z = 0;
  quad[1].u = 0;
  quad[1].v = 0;
  quad[1].color = 0xFFFFFFFF;

  quad[2].x = 0;
  quad[2].y = -1;
  quad[2].z = 0;
  quad[2].u = 1;
  quad[2].v = 1;
  quad[2].color = 0xFFFFFFFF;

  quad[3].x = 1.1f;
  quad[3].y = 0;
  quad[3].z = 0;
  quad[3].u = 1;
  quad[3].v = 0;
  quad[3].color = 0xFFFFFFFF;



  D3DXMATRIX m_trans;
  D3DXMatrixTranslation(&m_trans,-0.2f,-0.2f,-0.2f);
  m_piViewStack->MultMatrixLocal(&m_trans);



  D3DXMATRIX _id(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1);

  D3DXVECTOR3 out_v;
  D3DXVec3Project(&out_v,(D3DXVECTOR3*)q,&vp,m_piProjectionStack->GetTop(),m_piViewStack->GetTop(),&_id);

  D3DXVECTOR3 o;
  D3DXVECTOR3 _in(q_x,q_y,out_v.z);
  D3DXVec3Unproject(&o,&_in,&vp,m_piProjectionStack->GetTop(),m_piViewStack->GetTop(),&_id);

  q[0].x = o.x;
  q[0].y = o.y;

  D3DXMATRIX m;/*
  D3DXMatrixTranslation(&m,-0.5f,-0.5f,-0.5f);
  m_piViewStack->MultMatrixLocal(&m);*/

  m_piDirect3DDevice9->SetTransform(D3DTS_VIEW,m_piViewStack->GetTop());

  m_piDirect3DDevice9->BeginScene();

  m_piDirect3DDevice9->DrawPrimitiveUP(D3DPT_TRIANGLESTRIP,2,q,sizeof(VERTEX));

  m_piDirect3DDevice9->EndScene();

  

  D3DXVECTOR3 v;
  v.x = 0;
  v.y = 1;
  v.z = 0;
  
  D3DXMATRIX m_rot;
  D3DXMatrixRotationAxis(&m_rot,&v,m_fAngle);
  m_piViewStack->MultMatrixLocal(&m_rot);

  m_piDirect3DDevice9->SetTransform(D3DTS_VIEW,m_piViewStack->GetTop());

  

  m_piDirect3DDevice9->SetTexture(0,m_piTexture);

  m_piDirect3DDevice9->BeginScene();

  m_piDirect3DDevice9->DrawPrimitiveUP(D3DPT_TRIANGLESTRIP,2,quad,sizeof(VERTEX));

  m_piDirect3DDevice9->EndScene();



  quad[0].x = -0.1f;
  quad[0].y = 0;
  quad[0].z = 0;
  quad[0].u = 0;
  quad[0].v = 1;
  quad[0].color = 0xFFF00FFF;

  quad[1].x = 0;
  quad[1].y = 0.1f;
  quad[1].z = 0;
  quad[1].u = 0;
  quad[1].v = 0;
  quad[1].color = 0xFFFFFFFF;

  quad[2].x = 0;
  quad[2].y = -0.1f;
  quad[2].z = 0;
  quad[2].u = 1;
  quad[2].v = 1;
  quad[2].color = 0xFFFFFFFF;

  quad[3].x = 0.1f;
  quad[3].y = 0;
  quad[3].z = 0;
  quad[3].u = 1;
  quad[3].v = 0;
  quad[3].color = 0xFFFFFFFF;

  D3DXMatrixTranslation(&m,-0.5f,-0.5f,-0.5f);
  m_piViewStack->MultMatrixLocal(&m);

  m_piDirect3DDevice9->SetTransform(D3DTS_VIEW,m_piViewStack->GetTop());
  


  m_piDirect3DDevice9->BeginScene();

  m_piDirect3DDevice9->DrawPrimitiveUP(D3DPT_TRIANGLESTRIP,2,quad,sizeof(VERTEX));

  m_piDirect3DDevice9->EndScene();



  double r1 = 0.5;
  double r2 = 0.7;

  int iVertexCount = 196;

  VERTEX* pCircle = new VERTEX[iVertexCount];

  for (int i = 0;i < iVertexCount/2;i++)
  {
    double angle = 2*i*2*PI/iVertexCount;

    pCircle[2*i].x = (float)(r1*cos(angle));
    pCircle[2*i].y = (float)(r1*sin(angle));
    pCircle[2*i].z = 0;
    pCircle[2*i].color = 0xFFFFFFFF;
    //Circle[2*i].u = ;
    //Circle[2*i].v = ;

    pCircle[2*i+1].x = (float)(r2*cos(angle));
    pCircle[2*i+1].y = (float)(r2*sin(angle));
    pCircle[2*i+1].z = 0;
    pCircle[2*i+1].color = 0xFFFFFFFF;
    //Circle[2*i].u = ;
    //Circle[2*i].v = ;
  }

  delete [] pCircle;

  m_piDirect3DDevice9->SetFVF(D3DFVF_XYZ | D3DFVF_DIFFUSE | D3DFVF_TEX1);

  m_piDirect3DDevice9->SetRenderState(D3DRS_FILLMODE,D3DFILL_WIREFRAME);

  m_piDirect3DDevice9->BeginScene();

  m_piDirect3DDevice9->DrawPrimitiveUP(D3DPT_TRIANGLESTRIP,iVertexCount-2,pCircle,sizeof(VERTEX));

  m_piDirect3DDevice9->EndScene();



  m_piViewStack->Pop();
  m_piProjectionStack->Pop();

  m_piDirect3DDevice9->SetTransform(D3DTS_VIEW,m_piViewStack->GetTop());
  m_piDirect3DDevice9->SetTransform(D3DTS_PROJECTION,m_piViewStack->GetTop());

  m_piDirect3DDevice9->Present(NULL,NULL,/*AfxGetApp()->m_pMainWnd->m_hWnd*/NULL,NULL);



  m_fAngle += 0.01f;


	
  CView::OnTimer(nIDEvent);
}

void CD3D9TestAppView::OnMouseMove(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default

  q_x = (float)point.x;
  q_y = (float)point.y;
	
	CView::OnMouseMove(nFlags, point);
}
