// D3D9TestAppView.h : interface of the CD3D9TestAppView class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_D3D9TESTAPPVIEW_H__4A8EBE03_E41B_4EE5_B827_F58C9BE6DB5C__INCLUDED_)
#define AFX_D3D9TESTAPPVIEW_H__4A8EBE03_E41B_4EE5_B827_F58C9BE6DB5C__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <d3dx9.h>

class CD3D9TestAppView : public CView
{
protected: // create from serialization only
	CD3D9TestAppView();
	DECLARE_DYNCREATE(CD3D9TestAppView)

public:
  
  IDirect3D9*        m_piDirect3D9;
  IDirect3DDevice9*  m_piDirect3DDevice9;
  ID3DXMatrixStack*  m_piViewStack;
  ID3DXMatrixStack*  m_piProjectionStack;
  IDirect3DTexture9* m_piTexture;

  float              m_fAngle;
  
  void               InitializeDirect3D();

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CD3D9TestAppView)
	public:
	virtual void OnDraw(CDC* pDC);  // overridden to draw this view
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	protected:
	virtual BOOL OnPreparePrinting(CPrintInfo* pInfo);
	virtual void OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnEndPrinting(CDC* pDC, CPrintInfo* pInfo);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CD3D9TestAppView();

	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
  CD3D9TestAppDoc* GetDocument();

protected:

// Generated message map functions
protected:
	//{{AFX_MSG(CD3D9TestAppView)
	afx_msg void OnTimer(UINT nIDEvent);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnDestroy();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_D3D9TESTAPPVIEW_H__4A8EBE03_E41B_4EE5_B827_F58C9BE6DB5C__INCLUDED_)
