using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.Runtime.InteropServices;

namespace GL_CSharp
{
	/// <summary>
	/// Summary description for Form1.
	/// </summary>
	public class MainForm : System.Windows.Forms.Form
	{
    private System.ComponentModel.IContainer components;

		public MainForm()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
      this.components = new System.ComponentModel.Container();
      this.RenderTimer = new System.Windows.Forms.Timer(this.components);
      // 
      // RenderTimer
      // 
      this.RenderTimer.Interval = 50;
      this.RenderTimer.Tick += new System.EventHandler(this.RenderTimer_Tick);
      // 
      // MainForm
      // 
      this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
      this.ClientSize = new System.Drawing.Size(288, 293);
      this.Name = "MainForm";
      this.Text = "MainForm";
      this.Load += new System.EventHandler(this.MainForm_Load);
      this.Closed += new System.EventHandler(this.MainForm_Closed);

    }
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new MainForm());
		}

    [DllImport("user32.dll",EntryPoint="GetDC")]
    static extern IntPtr GetDC(
      IntPtr hWnd // handle to a window
    );

    [DllImport("user32.dll",EntryPoint="ReleaseDC")]
    static extern int ReleaseDC(
      IntPtr hWnd, // handle to window
      IntPtr hDC   // handle to device context
    );

    struct PIXELFORMATDESCRIPTOR
    {
      public Int16 nSize;
      public Int16 nVersion;
      public int   dwFlags;
      public byte  iPixelType;
      public byte  cColorBits;
      public byte  cRedBits;
      public byte  cRedShift;
      public byte  cGreenBits;
      public byte  cGreenShift;
      public byte  cBlueBits;
      public byte  cBlueShift;
      public byte  cAlphaBits;
      public byte  cAlphaShift;
      public byte  cAccumBits;
      public byte  cAccumRedBits;
      public byte  cAccumGreenBits;
      public byte  cAccumBlueBits;
      public byte  cAccumAlphaBits;
      public byte  cDepthBits;
      public byte  cStencilBits;
      public byte  cAuxBuffers;
      public byte  iLayerType;
      public byte  bReserved;
      public int   dwLayerMask;
      public int   dwVisibleMask;
      public int   dwDamageMask;
    };

    void ZeroPFD(ref PIXELFORMATDESCRIPTOR pfd)
    {
      pfd.nSize           = 0;
      pfd.nVersion        = 0;
      pfd.dwFlags         = 0;
      pfd.iPixelType      = 0;
      pfd.cColorBits      = 0;
      pfd.cRedBits        = 0;
      pfd.cRedShift       = 0;
      pfd.cGreenBits      = 0;
      pfd.cGreenShift     = 0;
      pfd.cBlueBits       = 0;
      pfd.cBlueShift      = 0;
      pfd.cAlphaBits      = 0;
      pfd.cAlphaShift     = 0;
      pfd.cAccumBits      = 0;
      pfd.cAccumRedBits   = 0;
      pfd.cAccumGreenBits = 0;
      pfd.cAccumBlueBits  = 0;
      pfd.cAccumAlphaBits = 0;
      pfd.cDepthBits      = 0;
      pfd.cStencilBits    = 0;
      pfd.cAuxBuffers     = 0;
      pfd.iLayerType      = 0;
      pfd.bReserved       = 0;
      pfd.dwLayerMask     = 0;
      pfd.dwVisibleMask   = 0;
      pfd.dwDamageMask    = 0;
    }

    const int sizeof_PIXELFORMATDESCRIPTOR = 40;
    const int PFD_DOUBLEBUFFER             = 0x00000001;
    const int PFD_DRAW_TO_WINDOW           = 0x00000004;
    const int PFD_SUPPORT_OPENGL           = 0x00000020;
    const int PFD_TYPE_RGBA                = 0;
    private System.Windows.Forms.Timer RenderTimer;
    const int PFD_MAIN_PLANE               = 0;

    [DllImport("gdi32.dll",EntryPoint="ChoosePixelFormat")]
    static extern int ChoosePixelFormat(
      IntPtr                    hdc, // device context to search for a best pixel format match
      ref PIXELFORMATDESCRIPTOR ppfd // pixel format for which a best match is sought
    );

    [DllImport("gdi32.dll",EntryPoint="SetPixelFormat")]
    static extern int SetPixelFormat(
      IntPtr                    hdc,          // device context whose pixel format the function attempts to set
      int                       iPixelFormat, // pixel format index (one-based)
      ref PIXELFORMATDESCRIPTOR ppfd          // pointer to logical pixel format specification
    );

    bool SetDCPixelFormat(IntPtr hDC)
    {
      PIXELFORMATDESCRIPTOR pfd = new PIXELFORMATDESCRIPTOR();
      int                   nPixelFormat;
  
      ZeroPFD(ref pfd);
  
      pfd.nSize = sizeof_PIXELFORMATDESCRIPTOR;
      pfd.nVersion = 1;
      pfd.dwFlags = PFD_DRAW_TO_WINDOW | PFD_SUPPORT_OPENGL | PFD_DOUBLEBUFFER;
      pfd.iPixelType = PFD_TYPE_RGBA;
      pfd.cColorBits = 24;
      pfd.cDepthBits = 16;
      pfd.iLayerType = PFD_MAIN_PLANE;
  
      nPixelFormat = ChoosePixelFormat(hDC,ref pfd);
  
      if (nPixelFormat == 0)
        return false;
      else
      {
        int iResult = SetPixelFormat(hDC,nPixelFormat,ref pfd);
    
        return iResult != 0;
      }
    }

    [DllImport("opengl32.dll",EntryPoint="wglCreateContext")]
    static extern IntPtr wglCreateContext(
      IntPtr hdc // device context of device that the rendering context will be suitable for
    );

    [DllImport("opengl32.dll",EntryPoint="wglDeleteContext")]
    static extern int wglDeleteContext(
      IntPtr hglrc // handle to the OpenGL rendering context to delete
    );

    [DllImport("opengl32.dll",EntryPoint="wglMakeCurrent")]
    static extern int wglMakeCurrent(
      IntPtr  hdc,   // device context of device that OpenGL calls are to be drawn on
      IntPtr  hglrc // OpenGL rendering context to be made the calling thread's current rendering context
    );

    const int GL_BACK = 0x0405;

    [DllImport("opengl32.dll",EntryPoint="glDrawBuffer")]
    static extern void glDrawBuffer(
      int mode   
    );

    [DllImport("opengl32.dll",EntryPoint="glViewport")]
    static extern void glViewport(
      int x,        
      int y,        
      int width,  
      int height  
    );

    const int GL_COLOR_BUFFER_BIT = 0x00004000;

    [DllImport("opengl32.dll",EntryPoint="glClear")]
    static extern void glClear(
      int mask   
    );

    const int GL_QUADS = 0x0007;

    [DllImport("opengl32.dll",EntryPoint="glBegin")]
    static extern void glBegin(
      int mode   
    );
 
    [DllImport("opengl32.dll",EntryPoint="glEnd")]
    static extern void glEnd();

    [DllImport("opengl32.dll",EntryPoint="glColor3d")]
    static extern void glColor3d(
      double red,     
      double green,   
      double blue     
    );

    [DllImport("opengl32.dll",EntryPoint="glVertex3d")]
    static extern void glVertex3d(
      double x, 
      double y, 
      double z  
    );

    [DllImport("gdi32.dll",EntryPoint="SwapBuffers")]
    static extern int SwapBuffers(
      IntPtr hdc // device context whose buffers get swapped
    );

    IntPtr m_hDC    = (IntPtr)null;
    IntPtr m_hRC    = (IntPtr)null;

    double m_dAngle = 0;

    private void MainForm_Load(object sender, System.EventArgs e)
    {
      RenderTimer.Enabled = true;
    }

    private void RenderTimer_Tick(object sender, System.EventArgs e)
    {
      if (m_hDC == (IntPtr)null)
      {
        m_hDC = GetDC(this.Handle);

        SetDCPixelFormat(m_hDC);

        m_hRC = wglCreateContext(m_hDC);

        if (m_hRC == (IntPtr)null)
        {
          ReleaseDC(this.Handle,m_hDC);

          m_hDC = GetDC(this.Handle);

          SetDCPixelFormat(m_hDC);

          m_hRC = wglCreateContext(m_hDC);
        }
      }

      wglMakeCurrent(m_hDC,m_hRC);

      glDrawBuffer(GL_BACK);

      glViewport(0,0,this.ClientRectangle.Width,this.ClientRectangle.Height);

      glClear(GL_COLOR_BUFFER_BIT);

      m_dAngle += 0.01;

      glBegin(GL_QUADS); 

      glColor3d(1,0,0);
      glVertex3d(Math.Cos(m_dAngle),Math.Sin(m_dAngle),0);

      glColor3d(0,1,0);
      glVertex3d(Math.Cos(m_dAngle+1.57),Math.Sin(m_dAngle+1.57),0);

      glColor3d(0,0,1);
      glVertex3d(-Math.Cos(m_dAngle),-Math.Sin(m_dAngle),0);

      glColor3d(0,1,1);
      glVertex3d(-Math.Cos(m_dAngle+1.57),-Math.Sin(m_dAngle+1.57),0);

      glEnd();

      wglMakeCurrent((IntPtr)null,(IntPtr)null);

      SwapBuffers(m_hDC);
    }

    private void MainForm_Closed(object sender, System.EventArgs e)
    {
      wglDeleteContext(m_hRC);

      ReleaseDC(this.Handle,m_hDC);
    }
	}
}
