// MakeGrayDlg.cpp : implementation file
//

#include "stdafx.h"
#include "MakeGray.h"
#include "MakeGrayDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMakeGrayDlg dialog

CMakeGrayDlg::CMakeGrayDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CMakeGrayDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CMakeGrayDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CMakeGrayDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMakeGrayDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CMakeGrayDlg, CDialog)
	//{{AFX_MSG_MAP(CMakeGrayDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_GO_BUTTON, OnGoButton)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMakeGrayDlg message handlers

BOOL CMakeGrayDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CMakeGrayDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CMakeGrayDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CMakeGrayDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

inline void MakeGrayC(DWORD* pData,DWORD dwPixelCount)
{
  DWORD dwValue;

  for (DWORD dw = 0;dw < dwPixelCount;dw++)
  {
    dwValue = ((pData[dw] & 0x000000FF) + ((pData[dw] & 0x0000FF00) >> 8) + ((pData[dw] & 0x00FF0000) >> 16))/3;

    pData[dw] = dwValue | (dwValue << 8) | (dwValue << 16);
  }
}

inline void MakeGrayPureAsm(DWORD* pData,DWORD dwPixelCount)
{
  __asm
  {
    push eax
    push ebx
    push ecx
    push edx

    mov edx,pData
    mov ecx,dwPixelCount
    shl ecx,2
__loop:
    jecxz __exit
    mov eax,0
    mov ebx,0
    mov bl,byte ptr[edx+ecx-4]
    add eax,ebx
    mov bl,byte ptr[edx+ecx-3]
    add eax,ebx
    mov bl,byte ptr[edx+ecx-2]
    add eax,ebx
    push edx
    mov ebx,3
    mov edx,0
    div ebx
    mov edx,eax
    shl edx,8
    or eax,edx
    shl edx,8
    or eax,edx
    pop edx
    mov byte ptr[edx+ecx-4],al
    mov byte ptr[edx+ecx-3],al
    mov byte ptr[edx+ecx-2],al
    sub ecx,3
    loop __loop
__exit:

    pop edx
    pop ecx
    pop ebx
    pop eax
  }
}

inline void MakeGrayMMX(DWORD* pData,DWORD dwPixelCount)
{
  __asm
  {
    push eax
    push ebx
    push ecx
    push edx
    
    mov eax,0
    mov edx,pData
    mov ecx,dwPixelCount
    shr ecx,1

    mov ebx,0xFF
    movd mm2,ebx
    psllq mm2,32
    movd mm3,ebx
    por mm2,mm3
    mov ebx,3
__loop:
    jecxz __exit
    movq mm0,qword ptr[edx+eax]
    movq mm1,mm0
    pand mm1,mm2
    movq mm4,mm1
    movq mm1,mm0
    psrlq mm1,8
    pand mm1,mm2
    paddd mm4,mm1
    movq mm1,mm0
    psrlq mm1,16
    pand mm1,mm2
    paddd mm4,mm1
    push eax
    push edx
    mov edx,0
    movd eax,mm4
    div ebx
    push eax
    psrlq mm4,32
    mov edx,0
    movd eax,mm4
    div ebx
    movd mm1,eax
    movq mm4,mm1
    psllq mm4,8
    por mm4,mm1
    psllq mm4,8
    por mm4,mm1
    psllq mm4,16
    pop eax
    movd mm1,eax
    por mm4,mm1
    psllq mm4,8
    por mm4,mm1
    psllq mm4,8
    por mm4,mm1
    pop edx
    pop eax
    movq qword ptr[edx+eax],mm4
    add eax,8
    loop __loop
__exit:

    emms    
    
    pop edx
    pop ecx
    pop ebx
    pop eax
  }
}

inline double GetSeconds(SYSTEMTIME* st)
{
  return 0.001*(int)st->wMilliseconds+st->wSecond+st->wMinute*60+st->wHour*3600+st->wDay*24*3600;
}

void MessageBoxSeconds(SYSTEMTIME* st1,SYSTEMTIME* st2)
{
  char seconds[100];
  gcvt(GetSeconds(st2)-GetSeconds(st1),10,seconds);

  strcat(seconds," seconds");

  MessageBoxA(NULL,seconds,"Message",MB_OK);
}

void CMakeGrayDlg::OnGoButton() 
{
  HDC hDestDC = ::GetDC(m_hWnd);

  BITMAPINFOHEADER bih;
  bih.biSize                = sizeof(bih);
  bih.biWidth               = 256;
  bih.biHeight              = 256;
  bih.biPlanes              = 1;
  bih.biBitCount            = 32;
  bih.biCompression         = BI_RGB;
  bih.biSizeImage           = 0;
  bih.biXPelsPerMeter       = bih.biWidth;
  bih.biYPelsPerMeter       = bih.biHeight;
  bih.biClrUsed             = 0;
  bih.biClrImportant        = 0;

  BITMAPINFO bi;
  bi.bmiHeader = bih;

  DWORD* pDIBits;

  HBITMAP hBitmap = ::CreateDIBSection(NULL,//hMemDC,
                                       &bi,
                                       DIB_RGB_COLORS,
                                       (void**)&pDIBits,
                                       NULL,
                                       0);

  DWORD* pBits = pDIBits;

  HDC hDC = CreateCompatibleDC(NULL);

  HBITMAP hPrevBitmap = (HBITMAP)SelectObject(hDC,hBitmap);



  int x,y;



  for (y = 0;y < 256;y++)
  {
    for (x = 0;x < 256;x++)
    {
      pDIBits[x+256*y] = x | (y << 8);

      pBits++;
    }
  }

  BitBlt(hDestDC,0,0,256,256,hDC,0,0,SRCCOPY);

  

  for (y = 0;y < 256;y++)
  {
    for (x = 0;x < 256;x++)
    {
      pDIBits[x+256*y] = x | (y << 8);

      pBits++;
    }
  }

  MakeGrayC(pDIBits,256*256);

  BitBlt(hDestDC,0,256,256,256,hDC,0,0,SRCCOPY);



  for (y = 0;y < 256;y++)
  {
    for (x = 0;x < 256;x++)
    {
      pDIBits[x+256*y] = x | (y << 8);

      pBits++;
    }
  }

  MakeGrayPureAsm(pDIBits,256*256);

  BitBlt(hDestDC,256,256,256,256,hDC,0,0,SRCCOPY);



  for (y = 0;y < 256;y++)
  {
    for (x = 0;x < 256;x++)
    {
      pDIBits[x+256*y] = x | (y << 8);

      pBits++;
    }
  }

  MakeGrayMMX(pDIBits,256*256);

  BitBlt(hDestDC,512,256,256,256,hDC,0,0,SRCCOPY);

  

  SelectObject(hDC,hPrevBitmap);

  DeleteObject(hBitmap);

  DeleteDC(hDC);

  ::ReleaseDC(m_hWnd,hDC);

  

  SYSTEMTIME st1,st2;

  DWORD dwCount = 1024*1024*128;

  DWORD* pData = new DWORD[dwCount];



  for (DWORD dw = 0;dw < dwCount;dw++)
    pData[dw] = dw;

  MessageBox("starting MakeGrayC()");

  GetSystemTime(&st1);

  MakeGrayC(pData,dwCount);

  GetSystemTime(&st2);

  MessageBoxSeconds(&st1,&st2);

  

  for (dw = 0;dw < dwCount;dw++)
    pData[dw] = dw;

  MessageBox("starting MakeGrayPureAsm()");

  GetSystemTime(&st1);

  MakeGrayPureAsm(pData,dwCount);

  GetSystemTime(&st2);

  MessageBoxSeconds(&st1,&st2);



  for (dw = 0;dw < dwCount;dw++)
    pData[dw] = dw;

  MessageBox("starting MakeGrayMMX()");
  
  GetSystemTime(&st1);

  MakeGrayMMX(pData,dwCount);

  GetSystemTime(&st2);

  MessageBoxSeconds(&st1,&st2);

  

  delete [] pData;	
}
