// OpenGL_TestAppView.cpp : implementation of the COpenGL_TestAppView class
//

#include "stdafx.h"
#include "OpenGL_TestApp.h"

#include "OpenGL_TestAppDoc.h"
#include "OpenGL_TestAppView.h"

#include <gl/gl.h>
#include <gl/glu.h>
#include <math.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

//*** TIMER EVENTS ***
#define TE_RENDERING               1

/////////////////////////////////////////////////////////////////////////////
// COpenGL_TestAppView

IMPLEMENT_DYNCREATE(COpenGL_TestAppView, CView)

BEGIN_MESSAGE_MAP(COpenGL_TestAppView, CView)
	//{{AFX_MSG_MAP(COpenGL_TestAppView)
	ON_WM_CREATE()
	ON_WM_SIZE()
	ON_WM_DESTROY()
	ON_WM_ERASEBKGND()
	ON_WM_TIMER()
	ON_WM_KEYDOWN()
	ON_WM_LBUTTONDOWN()
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CView::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// COpenGL_TestAppView construction/destruction

COpenGL_TestAppView::COpenGL_TestAppView()
{
	// TODO: add construction code here

  m_dAngle1 = 0.0;
  m_dAngle2 = 0.0;
  m_dAngle3 = 0.0;

  m_pVector[0] = 1;
  m_pVector[1] = 1;
  m_pVector[2] = 1;
}

COpenGL_TestAppView::~COpenGL_TestAppView()
{
}

BOOL COpenGL_TestAppView::SetDCPixelFormat()
{
  PIXELFORMATDESCRIPTOR PFD;
  int nPixelFormat;
  
  ZeroMemory(&PFD,sizeof(PFD));
  
  PFD.nSize = sizeof(PIXELFORMATDESCRIPTOR);
  PFD.nVersion = 1;
  PFD.dwFlags = PFD_DRAW_TO_WINDOW |
                PFD_SUPPORT_OPENGL |
                PFD_DOUBLEBUFFER;
  PFD.iPixelType = PFD_TYPE_RGBA;
  PFD.cColorBits = 24;
  PFD.cDepthBits = 32;
  PFD.iLayerType = PFD_MAIN_PLANE;
  
  nPixelFormat = ChoosePixelFormat(m_hDC,&PFD);
  
  if (nPixelFormat == 0)
    return FALSE;
  else
  {
    SetPixelFormat(m_hDC,nPixelFormat,&PFD);
    
    return TRUE;
  }
}

const int checkImageWidth  = 128;
const int checkImageHeight = 128;

DWORD* checkImage;

double rotateangle = 0;

void COpenGL_TestAppView::InitializeOpenGl()
{
  wglDeleteContext(m_hRC);

  m_hDC = ::GetDC(CView::m_hWnd);
  //SetPixelFormatDescriptor();

  SetDCPixelFormat();

  m_hRC = wglCreateContext(m_hDC);
  if (m_hRC == NULL)
    MessageBox("hRC == NULL");
  


  RECT rect;

  GetClientRect(&rect);

  m_iClientWidth = rect.right-rect.left;
  m_iClientHeight = rect.bottom-rect.top;

  glDrawBuffer(GL_BACK);

  glViewport(0,0,m_iClientWidth,m_iClientHeight); 

  glMatrixMode(GL_PROJECTION);

  //glFrustum(-1.0,1.0,-1.0,1.0,1.0,100.);

  //gluPerspective(90.0,1.0,1,10);

  glEnable(GL_SCISSOR_TEST);



  checkImage = new DWORD[checkImageWidth*checkImageHeight];

  for (int i = 0;i < checkImageHeight;i++)
  {
    for (int j = 0;j < checkImageWidth;j++)
    {
      checkImage[j+i*checkImageWidth] = 0xFF000000 | ((2*i) << 16);
    }
  }

  wglMakeCurrent(m_hDC,m_hRC);



  // set pixel storage mode
  /////////////////////////
  glPixelStorei(GL_UNPACK_ALIGNMENT,4);

  // set up the texture
  /////////////////////
  glGenTextures(1,&m_texname);
  glBindTexture(GL_TEXTURE_2D,m_texname);

  glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
  glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
  glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
  glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);

  glTexImage2D(GL_TEXTURE_2D,
               0,
               4,
               checkImageWidth,
               checkImageHeight,
               0,
               GL_RGBA,
               GL_UNSIGNED_BYTE,
               checkImage);

  glHint(GL_PERSPECTIVE_CORRECTION_HINT,GL_NICEST);



  wglMakeCurrent(NULL,NULL);
}

void COpenGL_TestAppView::FinalizeOpenGl()
{
  delete checkImage;

  wglMakeCurrent(NULL,NULL);

  wglDeleteContext(m_hRC);

  ::ReleaseDC(CView::m_hWnd,m_hDC);
}

typedef struct tagVERTEX3D
{
  double x;
  double y;
  double z;
} VERTEX3D;

#define sqr(NUM) ((NUM)*(NUM))
#define PI       3.1415

void DrawBezier(VERTEX3D Point1,VERTEX3D Point2,VERTEX3D Point3,VERTEX3D Point4)
{
  double k,p1,p2,p3,p4,x,y,z;

  glBegin(GL_LINE_STRIP);

  for (int C1 = 0;C1 <= 100;C1++)
  {
    k  = C1/100.0f;
    p1 = pow(1-k,3);
    p2 = 3*k*sqr(1-k);
    p3 = 3*sqr(k)*(1-k);
    p4 = pow(k,3);

    x = Point1.x*p1+Point2.x*p2+Point3.x*p3+Point4.x*p4;
    y = Point1.y*p1+Point2.y*p2+Point3.y*p3+Point4.y*p4;
    z = Point1.z*p1+Point2.z*p2+Point3.z*p3+Point4.z*p4;

    glVertex3d(x,y,z);
  }

  glEnd();
}

BYTE bAlpha = 0;

void COpenGL_TestAppView::PaintScene(CDC* pDC)
{
/*
  m_dAngle1 += 0.005;
  m_dAngle2 += 0.5;
*/

  m_dAngle3 += 0.005;

  wglMakeCurrent(pDC->m_hDC,m_hRC);

  glViewport(0,0,m_iClientWidth,m_iClientHeight);

  glEnable(GL_DEPTH_TEST);

  glDepthFunc(GL_GREATER);

  glClearDepth(0);

  glClear(GL_DEPTH_BUFFER_BIT);

  glClearColor(0.0,0.0,0.0,1.0);
  glClear(GL_COLOR_BUFFER_BIT);

  glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);

  glEnable(GL_BLEND);

  glShadeModel(GL_FLAT);



  glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);



  glFogi(GL_FOG_MODE,GL_EXP);

  glFogf(GL_FOG_DENSITY,1.0f);

  glFogf(GL_FOG_START,0);

  glFogf(GL_FOG_END,1);

  float colors[4];
  colors[0] = 1.0f;
  colors[1] = 1.0f;
  colors[2] = 1.0f;
  colors[3] = 1.0f;


  glFogfv(GL_FOG_COLOR,colors);

  glEnable(GL_FOG);
  


  glPushMatrix();

  glScaled(1.0,1.0,-1.0);



  glRotated(rotateangle,1,0,0);



  glRotated(m_dAngle2,0.0,1.0,0.0);

  glColor3d(0.0,0.0,0.0);

  glBegin(GL_QUADS); 
    glVertex3d(-0.5,-0.5,-0.5);
    glVertex3d(0.5,-0.5,-0.5);
    glVertex3d(0.5,0.5,-0.5);
    glVertex3d(-0.5,0.5,-0.5);
  glEnd();

  glColor3d(0.0,0.0,0.0);

  glBegin(GL_QUADS); 
    glVertex3d(-0.5,-0.5,0.5);
    glVertex3d(0.5,-0.5,-0.5);
    glVertex3d(0.5,0.5,-0.5);
    glVertex3d(-0.5,0.5,0.5);
  glEnd();



  glEnable(GL_TEXTURE_2D);

  glTexEnvf(GL_TEXTURE_ENV,GL_TEXTURE_ENV_MODE,GL_REPLACE);
  glBindTexture(GL_TEXTURE_2D,m_texname);

  glBegin(GL_QUADS);
    glTexCoord2f(0.0f,-2.0f); glVertex3f((float)cos(m_dAngle1),(float)sin(m_dAngle1),0.5f);
    glTexCoord2f(0.0f,2.0f); glVertex3f((float)cos(m_dAngle1-PI/2),(float)sin(m_dAngle1-PI/2),0.5f);
    glTexCoord2f(1.0f,2.0f); glVertex3f((float)cos(m_dAngle1-PI),(float)sin(m_dAngle1-PI),0.5f);
    glTexCoord2f(1.0f,-2.0f); glVertex3f((float)cos(m_dAngle1-3*PI/2),(float)sin(m_dAngle1-3*PI/2),0.5f);
  glEnd();

  glDisable(GL_TEXTURE_2D);



  VERTEX3D bez[4];
  bez[0].x = -0.7;
  bez[0].y = -0.5;
  bez[0].z = -0.1;
  bez[1].x = 0.2;
  bez[1].y = 0.3;
  bez[1].z = 0.8;
  bez[2].x = 0.8;
  bez[2].y = 0.9;
  bez[2].z = -0.1;
  bez[3].x = 0.2;
  bez[3].y = -0.4;
  bez[3].z = 0.4;

  DrawBezier(bez[0],bez[1],bez[2],bez[3]);



  double vrx = 0;
  double vry = 1;
  double vrz = 0;

  double r = 0.2;

  DWORD dwVertexCount = 32;

  double angleZ = PI/4;
  double angleX = PI/4;

  double* pVX = new double[dwVertexCount];
  double* pVY = new double[dwVertexCount];
  double* pVZ = new double[dwVertexCount];

  for (DWORD dw = 0;dw < dwVertexCount;dw++)
  {
    pVX[dw] = r*cos(dw*((2*PI)/dwVertexCount))*cos(angleZ);
    pVY[dw] = r*sin(dw*((2*PI)/dwVertexCount))*sin(angleZ) *sin(angleX);
    pVZ[dw] = r*sin(dw*((2*PI)/dwVertexCount))            *cos(angleX);
  }

  glBegin(GL_LINES);

  for (dw = 0;dw < dwVertexCount-1;dw++)
  {
    glVertex3d(pVX[dw],pVY[dw],pVZ[dw]);
    glVertex3d(pVX[dw+1],pVY[dw+1],pVZ[dw+1]);
  }

  glVertex3d(pVX[dwVertexCount-1],pVY[dwVertexCount-1],pVZ[dwVertexCount-1]);
  glVertex3d(pVX[0],pVY[0],pVZ[0]);

  glEnd();

  delete pVX;
  delete pVY;
  delete pVZ;



  glPopMatrix();



  glColor3d(0.2,0.7,1.0);

  glBegin(GL_LINES);

  glVertex3d(0,0,0);
  glVertex3dv(m_pVector);

  glEnd();

  double pVertex[3];
  pVertex[0] = 0;
  pVertex[1] = 0;
  pVertex[2] = 0.5;

  if (2*PI-m_dAngle3 < 5*(2*PI/360))
    cos(0);

  glColor3d(1.0,1.0,1.0);

  glBegin(GL_LINES);

  glVertex3d(0,0,0);
  glVertex3dv(pVertex);

  glEnd();



  glFlush();

  wglMakeCurrent(NULL,NULL);

  SwapBuffers(pDC->m_hDC);

}

BOOL COpenGL_TestAppView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// COpenGL_TestAppView drawing

void COpenGL_TestAppView::OnDraw(CDC* pDC)
{
	COpenGL_TestAppDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);
	// TODO: add draw code for native data here

  PaintScene(pDC);
}

/////////////////////////////////////////////////////////////////////////////
// COpenGL_TestAppView printing

BOOL COpenGL_TestAppView::OnPreparePrinting(CPrintInfo* pInfo)
{
	// default preparation
	return DoPreparePrinting(pInfo);
}

void COpenGL_TestAppView::OnBeginPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add extra initialization before printing
}

void COpenGL_TestAppView::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add cleanup after printing
}

/////////////////////////////////////////////////////////////////////////////
// COpenGL_TestAppView diagnostics

#ifdef _DEBUG
void COpenGL_TestAppView::AssertValid() const
{
	CView::AssertValid();
}

void COpenGL_TestAppView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

COpenGL_TestAppDoc* COpenGL_TestAppView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(COpenGL_TestAppDoc)));
	return (COpenGL_TestAppDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// COpenGL_TestAppView message handlers

int COpenGL_TestAppView::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CView::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	// TODO: Add your specialized creation code here

  MessageBox("You can control scene by keys: UP arrow,DOWN arrow,A,D,S,W,Z,E,M,N.");

  InitializeOpenGl();

  SetTimer(TE_RENDERING,50,NULL);
	
	return 0;
}

void COpenGL_TestAppView::OnSize(UINT nType, int cx, int cy) 
{
	CView::OnSize(nType, cx, cy);
	
	// TODO: Add your message handler code here

  RECT rect;

  GetClientRect(&rect);

  m_iClientWidth = rect.right-rect.left;
  m_iClientHeight = rect.bottom-rect.top;

  //glViewport(0,0,m_iClientWidth,m_iClientHeight);

/*  FinalizeOpenGl();
  InitializeOpenGl();*/
	
}

void COpenGL_TestAppView::OnDestroy() 
{
	CView::OnDestroy();
	
	// TODO: Add your message handler code here
	
  FinalizeOpenGl();
}

BOOL COpenGL_TestAppView::OnEraseBkgnd(CDC* pDC) 
{
	// TODO: Add your message handler code here and/or call default
	
	return FALSE;//CView::OnEraseBkgnd(pDC);
}

void COpenGL_TestAppView::OnTimer(UINT nIDEvent) 
{
	// TODO: Add your message handler code here and/or call default

  if (nIDEvent == TE_RENDERING)
  {
    RedrawWindow();//PaintScene();
  }
	
	CView::OnTimer(nIDEvent);
}

void COpenGL_TestAppView::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	// TODO: Add your message handler code here and/or call default

  if (nChar == 38) // KEY_UP
    rotateangle += 5;

  if (nChar == 40) // KEY_DOWN
    rotateangle -= 5;

  if (nChar == 65) // KEY_A
    m_pVector[0] -= 0.1;

  if (nChar == 68)// KEY_D
    m_pVector[0] += 0.1;

  if (nChar == 83) // KEY_S
    m_pVector[1] -= 0.1;

  if (nChar == 87) // KEY_W
    m_pVector[1] += 0.1;

  if (nChar == 90) // KEY_Z
    m_pVector[2] -= 0.1;

  if (nChar == 69) // KEY_E
    m_pVector[2] += 0.1;

  if (nChar == 77) // KEY_M
    bAlpha += 1;

  if (nChar == 78) // KEY_N
    bAlpha -= 1;
	
	CView::OnKeyDown(nChar, nRepCnt, nFlags);
}

void COpenGL_TestAppView::OnLButtonDown(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default

  CDC* pDC = GetDC();

  wglMakeCurrent(pDC->m_hDC,m_hRC);

  MessageBox((char*)glGetString(GL_VERSION));

  wglMakeCurrent(NULL,NULL);
	
	CView::OnLButtonDown(nFlags, point);
}
