unit Paintlib;

interface

const

{ COMMON CONSTANTS }

      ON  = 1;
      OFF = 0;

{ KEYS }

      ESC = #27;
      ENTER = #13;
      SPACE = #32;

{ PAINT MODES }

      PEN = 10;
      LINES = 11;
      BARS = 12;
      CIRCLES = 13;
      ELLIPSES = 14;
      WRITING = 15;

{ MOUSE POINTERS }

      ARROW = 30;

{ VIDEOMODES }

      TEXT25x80         = 0;           {text mode}

      VGA640x480x16     = 1;           {egavga.bgi}

      VGA640x480x256    = 2;           {svga256.bgi}
      VGA800x600x256    = 3;
      VGA1024x768x256   = 4;

      VESA800x600x16    = 5;           {vesa16.bgi}
      VESA1024x768x16   = 6;
      VESA1280x1024x16  = 7;

      VESA640x480x256   = $101;        {BIOS modes}
      VESA800x600x256   = $103;
      VESA1024x768x256  = $105;
      VESA1280x1024x256 = $107;

{ OTHERS }

      BIOS_GET_IMAGE = 0;
      BGI_GET_IMAGE  = 1;

{ END OF CONST }


procedure MouseCursor(switch:integer);
procedure SetMouseSensitivity(xsen:byte;ysen:byte);
procedure SetMouseExtent(extentx:integer;extenty:integer);
procedure SetMousePointer(switch:integer);
procedure EmulateMCursor(mcursorx:integer;
                         mcursory:integer;
                         mpointer:byte;
                         mpointercolor:byte);
function  Vgetpixel(pixelx:integer;pixely:integer):byte;
procedure Vputpixel(pixelx:integer;pixely:integer;pixelcolor:byte);
procedure GetMouseBackground(mxpos:integer;mypos:integer;service:byte);
procedure PutMouseBackground(mxpos:integer;mypos:integer;service:byte);
procedure CreateWindow(name:string;
                       horizontalpos:integer;
                       verticalpos:integer;
                       width:integer;
                       height:integer;
                       fillcolor:byte;
                       tempfile:string;
                       menu:byte;
                       menucontent:string);

implementation

uses dos,graph;

var regs:registers;
    pixelsx,pixelsy:byte;
    MBackground:array[0..10,0..10] of byte;

procedure MouseCursor(switch:integer);
begin
   if switch = ON then
   asm mov ax,$01
       int $33
   end;
   if switch = OFF then
   asm mov ax,$02
       int $33
   end;
end;

procedure SetMousePointer(switch:integer);
var MCursor_Def:array[0..31] of word;
    fill:integer;
begin

   if switch = ARROW then
   begin
      MCursor_Def[0]:=$FFFF;        {  1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1  }
      MCursor_Def[1]:=$FFFF;        {  1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1  }
      MCursor_Def[2]:=$BFFF;        {  1 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1  }
      MCursor_Def[3]:=$9FFF;        {  1 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1  }
      MCursor_Def[4]:=$8FFF;        {  1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1  }
      MCursor_Def[5]:=$87FF;        {  1 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1  }
      MCursor_Def[6]:=$83FF;        {  1 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1  }
      MCursor_Def[7]:=$81FF;        {  1 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1  }
      MCursor_Def[8]:=$83FF;        {  1 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1  }
      MCursor_Def[9]:=$BFFF;        {  1 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1  }
      MCursor_Def[10]:=$FFFF;       {  1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1  }
      MCursor_Def[11]:=$FFFF;       {  1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1  }
      MCursor_Def[12]:=$FFFF;       {  1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1  }
      MCursor_Def[13]:=$FFFF;       {  1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1  }
      MCursor_Def[14]:=$FFFF;       {  1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1  }
      MCursor_Def[15]:=$FFFF;       {  1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1  }

      MCursor_Def[16]:=$8000;       {  1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  }
      MCursor_Def[17]:=$C000;       {  1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0  }
      MCursor_Def[18]:=$E000;       {  1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0  }
      MCursor_Def[19]:=$F000;       {  1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0  }
      MCursor_Def[20]:=$F800;       {  1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0  }
      MCursor_Def[21]:=$FC00;       {  1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0  }
      MCursor_Def[22]:=$FE00;       {  1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0  }
      MCursor_Def[23]:=$FF00;       {  1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0  }
      MCursor_Def[24]:=$F800;       {  1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0  }
      MCursor_Def[25]:=$CC00;       {  1 1 0 0 1 1 0 0 0 0 0 0 0 0 0 0  }
      MCursor_Def[26]:=$8C00;       {  1 0 0 0 1 1 0 0 0 0 0 0 0 0 0 0  }
      MCursor_Def[27]:=$600;        {  0 0 0 0 0 1 1 0 0 0 0 0 0 0 0 0  }
      MCursor_Def[28]:=$600;        {  0 0 0 0 0 1 1 0 0 0 0 0 0 0 0 0  }
      MCursor_Def[29]:=$0;          {  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  }
      MCursor_Def[30]:=$0;          {  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  }
      MCursor_Def[31]:=$0;          {  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  }

      regs.ax:=$9;
      regs.bx:=$0;
      regs.cx:=$0;
      regs.dx:=ofs(MCursor_Def);
      regs.es:=seg(MCursor_Def);
      intr($33,regs);

   end;

   if switch = PEN then
   begin
      for fill:=0 to 15 do
      begin
         MCursor_Def[fill]:=65535;
      end;

      MCursor_Def[16]:=$10;        {  0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0  }
      MCursor_Def[17]:=$28;        {  0 0 0 0 0 0 0 0 0 0 1 0 1 0 0 0  }
      MCursor_Def[18]:=$44;        {  0 0 0 0 0 0 0 0 0 1 0 0 0 1 0 0  }
      MCursor_Def[19]:=$82;        {  0 0 0 0 0 0 0 0 1 0 0 0 0 0 1 0  }
      MCursor_Def[20]:=$101;       {  0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 1  }
      MCursor_Def[21]:=$202;       {  0 0 0 0 0 0 1 0 0 0 0 0 0 0 1 0  }
      MCursor_Def[22]:=$404;       {  0 0 0 0 0 1 0 0 0 0 0 0 0 1 0 0  }
      MCursor_Def[23]:=$808;       {  0 0 0 0 1 0 0 0 0 0 0 0 1 0 0 0  }
      MCursor_Def[24]:=$1010;      {  0 0 0 1 0 0 0 0 0 0 0 1 0 0 0 0  }
      MCursor_Def[25]:=$2020;      {  0 0 1 0 0 0 0 0 0 0 1 0 0 0 0 0  }
      MCursor_Def[26]:=$4040;      {  0 1 0 0 0 0 0 0 0 1 0 0 0 0 0 0  }
      MCursor_Def[27]:=$8080;      {  1 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0  }
      MCursor_Def[28]:=$8100;      {  1 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0  }
      MCursor_Def[29]:=$8200;      {  1 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0  }
      MCursor_Def[30]:=$8400;      {  1 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0  }
      MCursor_Def[31]:=$F800;      {  1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0  }

      regs.ax:=$9;
      regs.bx:=$0;
      regs.cx:=$F;
      regs.dx:=ofs(MCursor_Def);
      regs.es:=seg(MCursor_Def);
      intr($33,regs);
   end;
end;

procedure SetMouseSensitivity(xsen:byte;ysen:byte);
begin
   regs.ax:=$0f;
   regs.cx:=xsen;
   regs.dx:=ysen;
   intr($33,regs);
end;

procedure SetMouseExtent(extentx:integer;extenty:integer);
begin
   regs.ax:=$07;
   regs.cx:=0;
   regs.dx:=(extentx-1)*8;
   intr($33,regs);

   regs.ax:=$08;
   regs.cx:=0;
   regs.dx:=(extenty-1)*8;
   intr($33,regs);
end;

procedure EmulateMCursor(mcursorx:integer;
                         mcursory:integer;
                         mpointer:byte;
                         mpointercolor:byte);
var actualcolor:byte;
begin
   actualcolor:=getcolor;
   setcolor(mpointercolor);

   if mpointer = ARROW then
   begin
      line(mcursorx,mcursory,mcursorx,mcursory+10);
      line(mcursorx+1,mcursory+10,mcursorx+7,mcursory+7);
      line(mcursorx+1,mcursory+1,mcursorx+7,mcursory+7);
   end;
   if mpointer = PEN then
   begin
      line(mcursorx,mcursory+10,mcursorx+2,mcursory+10);
      line(mcursorx+3,mcursory+9,mcursorx+10,mcursory+2);
      line(mcursorx+9,mcursory+1,mcursorx+8,mcursory);
      line(mcursorx+7,mcursory+1,mcursorx,mcursory+8);
      line(mcursorx,mcursory+9,mcursorx,mcursory+10);
   end;
   setcolor(actualcolor);
end;

function Vgetpixel(pixelx:integer;pixely:integer):byte;
begin
   regs.ah:=$0d;
   regs.bh:=$00;
   regs.cx:=pixelx;
   regs.dx:=pixely;
   intr($10,regs);

   Vgetpixel:=regs.al;
end;

procedure Vputpixel(pixelx:integer;pixely:integer;pixelcolor:byte);
begin
   regs.ah:=$0c;
   regs.bh:=$00;
   regs.cx:=pixelx;
   regs.dx:=pixely;
   regs.al:=pixelcolor;
   intr($10,regs);
end;

procedure GetMouseBackground(mxpos:integer;mypos:integer;service:byte);
begin
   if service = BGI_GET_IMAGE then
   begin
      for pixelsy:=0 to 10 do
      begin
         for pixelsx:=0 to 10 do
         begin
            MBackground[pixelsx,pixelsy]:=getpixel(mxpos+pixelsx,
                                                   mypos+pixelsy);
         end;
      end;
   end;

   if service = BIOS_GET_IMAGE then
   begin
      for pixelsy:=0 to 10 do
      begin
         for pixelsx:=0 to 10 do
         begin
            MBackground[pixelsx,pixelsy]:=Vgetpixel(mxpos+pixelsx,
                                                    mypos+pixelsy);
         end;
      end;
   end;
end;

procedure PutMouseBackground(mxpos:integer;mypos:integer;service:byte);
begin
   if service = BGI_GET_IMAGE then
   begin
      for pixelsy:=0 to 10 do
      begin
         for pixelsx:=0 to 10 do
         begin
            putpixel(mxpos+pixelsx,mypos+pixelsy,
                     MBackground[pixelsx,pixelsy]);
         end;
      end;
   end;

   if service = BIOS_GET_IMAGE then
   begin
      for pixelsy:=0 to 10 do
      begin
         for pixelsx:=0 to 10 do
         begin
            Vputpixel(mxpos+pixelsx,mypos+pixelsy,
                      MBackground[pixelsx,pixelsy]);
         end;
      end;
   end;
end;

procedure CreateWindow(name:string;
                       horizontalpos:integer;
                       verticalpos:integer;
                       width:integer;
                       height:integer;
                       fillcolor:byte;
                       tempfile:string;
                       menu:byte;
                       menucontent:string);
begin



   setcolor(BLACK);
   line(horizontalpos,verticalpos,horizontalpos,verticalpos+height-1);
   line(horizontalpos+1,
        verticalpos+height-1,
        horizontalpos+width-1,
        verticalpos+height-1);
   setcolor(WHITE);
   line(horizontalpos+width-1,
        verticalpos+height-2,
        horizontalpos+width-1,
        verticalpos);
   line(horizontalpos+width-2,
        verticalpos,
        horizontalpos,
        verticalpos);
   setcolor(7);
   line(horizontalpos+1,
        verticalpos+1,
        horizontalpos+1,
        verticalpos+height-2);
   line(horizontalpos+2,
        verticalpos+height-2,
        horizontalpos+width-2,
        verticalpos+height-2);
   line(horizontalpos+width-2,
        verticalpos+height-3,
        horizontalpos+width-2,
        verticalpos+1);
   line(horizontalpos+width-3,verticalpos+1,horizontalpos+1,verticalpos+1);
   line(horizontalpos+2,
        verticalpos+2,
        horizontalpos+2,
        verticalpos+height-3);
   line(horizontalpos+3,
        verticalpos+height-3,
        horizontalpos+width-3,
        verticalpos+height-3);
   line(horizontalpos+width-3,
        verticalpos+height-4,
        horizontalpos+width-3,
        verticalpos+2);
   line(horizontalpos+width-4,
        verticalpos+2,
        horizontalpos+2,
        verticalpos+2);
   setcolor(8);
   line(horizontalpos+width-4,
        verticalpos+height-4,
        horizontalpos+width-4,
        verticalpos+3);
   line(horizontalpos+width-5,verticalpos+3,horizontalpos+3,verticalpos+3);
   setcolor(WHITE);
   line(horizontalpos+3,
        verticalpos+4,
        horizontalpos+3,
        verticalpos+height-4);
   line(horizontalpos+4,
        verticalpos+height-4,
        horizontalpos+width-4,
        verticalpos+height-4);

   setfillstyle(1,1);
   bar(horizontalpos+4,verticalpos+4,horizontalpos+width-5,verticalpos+17);
   setfillstyle(1,fillcolor);
   bar(horizontalpos+4,
       verticalpos+18,
       horizontalpos+width-5,
       verticalpos+height-5);
   settextstyle(2,0,0);
   outtextxy(horizontalpos+7,verticalpos+4,name);

   if (fillcolor = 15) then
   begin
      setcolor(7);
      line(horizontalpos+4,
           verticalpos+18,
           horizontalpos+4,
           verticalpos+height-5);
      line(horizontalpos+5,
           verticalpos+height-5,
           horizontalpos+width-5,
           verticalpos+height-5);
   end;

   if menu = 1 then
   begin
      setfillstyle(1,7);
      bar(horizontalpos+4,
          verticalpos+18,
          horizontalpos+width-5,
          verticalpos+31);
      setcolor(0);
      outtextxy(horizontalpos+7,
                verticalpos+18,
                menucontent);
   end;
end;

end.
