program Power_Paint;

{   This program is created for making games graphics.       }
{   Produced by LBsoft inc. All rights reserved. (C) 2000.   }

uses dos,crt,graph,paintlib;
var regs:registers;
    ngf,tempfile:text;
    Image:file of char;
    cmdparam:string;
    color:byte;
    menustatus:byte;
    key,readchar:char;
    oldmousex,oldmousey,newmousex,newmousey:integer;
    videomode,newvideomode:integer;
    paintmode:byte;
    menuxpos,menuypos:integer;
    PictureFileName:string;

const defaulttempfile = 'painting.tmp';
      PaintDir = 'd:\';




{ Common Functions: }
          {
function Button(bx,by:integer;inscription:string):integer;
var length:word;
begin

   setfillstyle(1,7);
   bar(bx,by,bx+19,by+59);

   setcolor(0);
   moveto(bx,by);
   lineto(bx,by+20);
   lineto(bx+59,by+19);
   setcolor(15);
   lineto(bx+59,by);
   lineto(bx,by);

   length:=textwidth(inscription);
   outtextxy(bx+((60-length) div 2),by+3,inscription);

end;                                          }





{ Particular Functions }

procedure SetVideoMode(mode:integer);
var Gd,Gm,drvdetect:integer;
begin
   if (videomode = VGA640x480x16)    or         {all BGI drivers}
      (videomode = VGA640x480x256)   or
      (videomode = VGA800x600x256)   or
      (videomode = VGA1024x768x256)  or
      (videomode = VESA800x600x16)   or
      (videomode = VESA1024x768x16)  or
      (videomode = VESA1280x1024x16) then
   begin
      closegraph;
      restorecrtmode;
   end;
   if (videomode = VESA640x480x256)   or         {BIOS vesamodes}
      (videomode = VESA800x600x256)   or
      (videomode = VESA1024x768x256)  or
      (videomode = VESA1280x1024x256) then
   begin
      regs.ah:=$00;
      regs.al:=$03;
      intr($10,regs);
   end;

   case mode of

      {EGAVGA.BGI mode}
      VGA640x480x16:begin
                       Gd:=detect;
                       initgraph(Gd,Gm,PaintDir);
                    end;

      {SVGA256.BGI modes}
      VGA640x480x256:begin
                        Gd:=installuserdriver('SVGA256',@drvdetect);
                        Gm:=2;
                        initgraph(Gd,Gm,PaintDir);

                        SetMouseExtent(640,480);
                        SetMouseSensitivity(2,2);
                     end;

      VGA800x600x256:begin
                        Gd:=installuserdriver('SVGA256',@drvdetect);
                        Gm:=3;
                        initgraph(Gd,Gm,PaintDir);

                        SetMouseExtent(800,600);
                        SetMouseSensitivity(2,2);
                     end;

      VGA1024x768x256:begin
                         Gd:=installuserdriver('SVGA256',@drvdetect);
                         Gm:=4;
                         initgraph(Gd,Gm,PaintDir);

                         SetMouseExtent(1024,768);
                         SetMouseSensitivity(2,2);
                      end;

      {VESA16.BGI modes}
      VESA800x600x16:begin
                        Gd:=installuserdriver('VESA16',@drvdetect);
                        Gm:=0;
                        initgraph(Gd,Gm,PaintDir);

                        SetMouseExtent(800,600);
                        SetMouseSensitivity(2,2);
                     end;

      VESA1024x768x16:begin
                         Gd:=installuserdriver('VESA16',@drvdetect);
                         Gm:=1;
                         initgraph(Gd,Gm,PaintDir);

                         SetMouseExtent(1024,768);
                         SetMouseSensitivity(1,1);
                      end;

      VESA1280x1024x16:begin
                          Gd:=installuserdriver('VESA16',@drvdetect);
                          Gm:=2;
                          initgraph(Gd,Gm,PaintDir);

                          SetMouseExtent(1280,1024);
                          SetMouseSensitivity(0,0);
                       end;

      {BIOS modes}
      VESA640x480x256:begin
                         regs.ax:=$4f02;
                         regs.bx:=mode;
                         intr($10,regs);

                         SetMouseExtent(640,480);
                         SetMouseSensitivity(2,2);
                      end;

      VESA800x600x256:begin
                         regs.ax:=$4f02;
                         regs.bx:=mode;
                         intr($10,regs);

                         SetMouseExtent(800,600);
                         SetMouseSensitivity(2,2);
                      end;

      VESA1024x768x256:begin
                          regs.ax:=$4f02;
                          regs.bx:=mode;
                          intr($10,regs);

                          SetMouseExtent(1024,768);
                          SetMouseSensitivity(1,1);
                       end;

      VESA1280x1024x256:begin
                           regs.ax:=$4f02;
                           regs.bx:=mode;
                           intr($10,regs);

                           SetMouseExtent(1280,1024);
                           SetMouseSensitivity(0,0);
                        end;
   end;
   videomode:=mode;
end;

procedure LoadPicture(ngf_file:string);
var xpos,ypos:integer;
    pixelcolor:byte;
    asciicolor:char;
    multiplier,timer:longint;
    pictureformat:string;
    convertedcolor:integer;
    counter:integer;
begin

   assign(ngf,ngf_file);
   filemode:=2;
   reset(ngf);

   readln(ngf);
   readln(ngf,pictureformat);

   counter:=0;

   if pictureformat = 'ngf' then
   for ypos:=0 to 479 do
   begin
      for xpos:=0 to 639 do
      begin
         read(ngf,asciicolor);
         putpixel(xpos,ypos,ord(asciicolor));
      end;
      counter:=counter+1;
      if counter = 50 then
      begin
         readln(ngf);
         counter:=0;
      end;
   end;

   if pictureformat = 'irc' then
   begin
      ypos:=0;
      xpos:=0;
      while not Eof(ngf) do
      begin
         readln(ngf,pixelcolor);
         readln(ngf,multiplier);
         for timer:=1 to multiplier do
         begin
            if xpos > 639 then
            begin
               xpos:=0;
               ypos:=ypos+1;
            end;
            putpixel(xpos,ypos,pixelcolor);
            xpos:=xpos+1;
         end;
      end;
   end;

   if pictureformat = 'fec' then
   begin
      readln(ngf,pixelcolor);
      setfillstyle(1,pixelcolor);
      floodfill(320,240,GREEN);

      while not Eof(ngf) do
      begin
         readln(ngf,xpos);
         if xpos < 0 then
         begin
            pixelcolor:= 0 - xpos;
         end
         else
         begin
            readln(ngf,ypos);
            putpixel(xpos,ypos,pixelcolor);
         end;
      end;
   end;

   close(ngf);

end;

procedure SaveNGF(filename:string);
var xpos,ypos:integer;
    counter:integer;
begin

   assign(ngf,filename);
   filemode:=2;
   rewrite(ngf);


   writeln(ngf,'Image file for program Power Paint produced by LBsoft');
   writeln(ngf,'ngf');

   counter:=0;

   for ypos:=0 to 479 do
   begin
      for xpos:=0 to 639 do
      begin
         write(ngf,chr(getpixel(xpos,ypos)));
      end;
      counter:=counter+1;
      if counter = 50 then
      begin
         writeln(ngf);
         counter:=0;
      end;
   end;

   close(ngf);

end;

procedure SaveIRC;
var xpos,ypos:integer;
    pixelcolor,hlpcolor:byte;
    multiplier:longint;
begin

   assign(ngf,'c:\temp\!sureal!.irc');
   rewrite(ngf);
   close(ngf);
   filemode:=2;
   append(ngf);

   writeln(ngf,'Image of Repeating Colors for program PAINT produced by LBsoft');
   writeln(ngf,'irc');

   for ypos:=0 to 479 do
   begin
      for xpos:=0 to 639 do
      begin
         pixelcolor:=getpixel(xpos,ypos);
         if (xpos=0) and (ypos=0) then
         begin
            hlpcolor:=pixelcolor;
            multiplier:=1;
         end
         else
         begin
            if pixelcolor = hlpcolor then
            begin
               multiplier:=multiplier+1;
            end
            else
            begin
               writeln(ngf,hlpcolor);
               writeln(ngf,multiplier);
               multiplier:=1;
               hlpcolor:=pixelcolor;
            end;
         end;
      end;
   end;

   writeln(ngf,hlpcolor);
   writeln(ngf,multiplier);

   close(ngf);

end;

procedure SaveFEC;
var pixelcolor:byte;
    xpos,ypos:integer;
    colors:array[0..255] of longint;
    pixels:longint;
    maxcolor:byte;
    convertedcolor:integer;
    timer:byte;
begin

   for timer:=0 to 255 do
   colors[timer]:=0;

   assign(ngf,'c:\temp\!sureal!.fec');
   rewrite(ngf);
   close(ngf);
   filemode:=2;
   append(ngf);

   writeln(ngf,'Format with Eliminated Colour for program PAINT produced by LBsoft');
   writeln(ngf,'fec');

   for ypos:=0 to 479 do
   begin
      for xpos:=0 to 639 do
      begin
         pixelcolor:=getpixel(xpos,ypos);
         colors[pixelcolor]:=colors[pixelcolor]+1;
      end;
   end;

   pixels:=colors[0];
   maxcolor:=0;

   for timer:=1 to 255 do
   begin
      if colors[timer] > pixels then
      begin
         pixels:=colors[timer];
         maxcolor:=timer;
      end;
   end;

   writeln(ngf,maxcolor);

   for timer:=0 to 255 do
   begin
      if colors[timer] > 0 then
      begin
         if timer <> maxcolor then
         begin
            convertedcolor:= 0 - timer;
            writeln(ngf,convertedcolor);
            for ypos:=0 to 479 do
            begin
               for xpos:=0 to 639 do
               begin
                  pixelcolor:=getpixel(xpos,ypos);
                  if pixelcolor = timer then
                  begin
                     writeln(ngf,xpos);
                     writeln(ngf,ypos);
                  end;
               end;
            end;
         end;
      end;
   end;

   close(ngf);

end;

procedure SaveTempFile(left_upper_cornerx:integer;
                       left_upper_cornery:integer;
                       right_lower_cornerx:integer;
                       right_lower_cornery:integer;
                       filename:string);
var xpos,ypos:integer;
    pixelcolor:byte;
begin

   assign(tempfile,filename);
   rewrite(tempfile);
   close(tempfile);

   filemode:=2;
   append(tempfile);

   writeln(tempfile,'TEMP file for program PAINTING produced by LBsoft, do not modify!');
   writeln(tempfile,'temp');

   writeln(tempfile,left_upper_cornerx);
   writeln(tempfile,left_upper_cornery);

   writeln(tempfile,right_lower_cornerx);
   writeln(tempfile,right_lower_cornery);

   for ypos:=left_upper_cornery to right_lower_cornery do
   begin
      for xpos:=left_upper_cornerx to right_lower_cornerx do
      begin
         pixelcolor:=getpixel(xpos,ypos);
         writeln(tempfile,pixelcolor);
      end;
   end;

   close(tempfile);

end;

procedure LoadTempFile(filename:string);
var xpos,ypos:integer;
    pixelcolor:byte;
    left_upper_cornerx,left_upper_cornery:integer;
    right_lower_cornerx,right_lower_cornery:integer;
begin

   assign(tempfile,filename);
   filemode:=2;
   reset(tempfile);

   readln(tempfile);
   readln(tempfile);

   readln(tempfile,left_upper_cornerx);
   readln(tempfile,left_upper_cornery);

   readln(tempfile,right_lower_cornerx);
   readln(tempfile,right_lower_cornery);

   for ypos:=left_upper_cornery to right_lower_cornery do
   begin
      for xpos:=left_upper_cornerx to right_lower_cornerx do
      begin
         readln(tempfile,pixelcolor);
         putpixel(xpos,ypos,pixelcolor);
      end;
   end;

   close(tempfile);

end;


procedure Menu(menux:integer;menuy:integer);
var pixelcolor,colors:byte;
begin

   if menustatus = OFF then
   begin

      SaveTempFile(menux,menuy,menux+300,menuy+350,defaulttempfile);

    {  setfillstyle(1,7);
      bar(0,220,639,259);



      setcolor(15);

      outtextxy(4,220,'Load');
      outtextxy(50,220,'IRC');
      outtextxy(100,220,'NGF');
      outtextxy(150,220,'FEC');
      outtextxy(250,220,'pen');
      outtextxy(300,220,'writing');
      outtextxy(400,220,'lines');          }

      CreateWindow('Power Paint Menu',
                   menux,
                   menuy,
                   300,
                   350,
                   15,
                   '',
                   1,
                   'Save   Options   Help   Exit');


      for colors:=0 to 63 do
      begin
         setcolor(colors);
         line(menux+21+4*colors,
              menuy+40,
              menux+21+4*colors,
              menuy+45);
         line(menux+22+4*colors,
              menuy+40,
              menux+22+4*colors,
              menuy+45);
         line(menux+23+4*colors,
              menuy+40,
              menux+23+4*colors,
              menuy+45);
         line(menux+24+4*colors,
              menuy+40,
              menux+24+4*colors,
              menuy+45);
      end;

      for colors:=64 to 127 do
      begin
         setcolor(colors);
         line((menux+21+4*colors)-256,
              menuy+46,
              (menux+21+4*colors)-256,
              menuy+50);
         line((menux+22+4*colors)-256,
              menuy+46,
              (menux+22+4*colors)-256,
              menuy+50);
         line((menux+23+4*colors)-256,
              menuy+46,
              (menux+23+4*colors)-256,
              menuy+50);
         line((menux+24+4*colors)-256,
              menuy+46,
              (menux+24+4*colors)-256,
              menuy+50);
      end;

      for colors:=128 to 191 do
      begin
         setcolor(colors);
         line((menux+21+4*colors)-512,
              menuy+51,
              (menux+21+4*colors)-512,
              menuy+55);
         line((menux+22+4*colors)-512,
              menuy+51,
              (menux+22+4*colors)-512,
              menuy+55);
         line((menux+23+4*colors)-512,
              menuy+51,
              (menux+23+4*colors)-512,
              menuy+55);
         line((menux+24+4*colors)-512,
              menuy+51,
              (menux+24+4*colors)-512,
              menuy+55);
      end;

      for colors:=192 to 255 do
      begin
         setcolor(colors);
         line((menux+21+4*colors)-768,
              menuy+56,
              (menux+21+4*colors)-768,
              menuy+60);
         line((menux+22+4*colors)-768,
              menuy+56,
              (menux+22+4*colors)-768,
              menuy+60);
         line((menux+23+4*colors)-768,
              menuy+56,
              (menux+23+4*colors)-768,
              menuy+60);
         line((menux+24+4*colors)-768,
              menuy+56,
              (menux+24+4*colors)-768,
              menuy+60);
      end;



      menuxpos:=menux;
      menuypos:=menuy;
      menustatus:=ON;

   end
   else
   begin
      LoadTempFile(defaulttempfile);
      menustatus:=OFF;
   end;

end;

procedure SaveMenu;
var filename:string;
    filenamelength:byte absolute filename;  f:text;
begin
   SaveTempFile(100,200,539,240,'savefile.tmp');
   MouseCursor(OFF);
   CreateWindow('Save as',100,200,439,40,15,'',0,'');

   filename:='My Picture.image';
   filenamelength:=16;

   settextstyle(0,0,0);
   setcolor(0);

   repeat
      setcolor(0);
      outtextxy(108,222,filename);

      if filenamelength < 53 then
      begin
         moveto(108+8*filenamelength,232);
         lineto(113+8*filenamelength,232);
      end
      else
      begin
         moveto(108+8*(filenamelength-1),232);
         lineto(113+8*(filenamelength-1),232);
      end;

      key:=readkey;
      if (key = chr(8)) then
      begin
         if filenamelength > 0 then
         begin
            setcolor(15);
            if filenamelength < 53 then
            begin
               moveto(108+8*filenamelength,232);
               lineto(113+8*filenamelength,232);
            end
            else
            begin
               moveto(108+8*(filenamelength-1),232);
               lineto(113+8*(filenamelength-1),232);
            end;

            dec(filenamelength);
            setfillstyle(1,15);
            bar(105,218,534,232);
         end;
      end
      else

      begin
         setcolor(15);
         if filenamelength < 53 then
         begin
            moveto(108+8*filenamelength,232);
            lineto(113+8*filenamelength,232);
         end
         else
         begin
            moveto(108+8*(filenamelength-1),232);
            lineto(113+8*(filenamelength-1),232);
         end;

         if filenamelength < 53 then
         inc(filenamelength);
         filename[filenamelength]:=key;
      end;



   until (key = ENTER) or (key = ESC);

   LoadTempFile('savefile.tmp');

   dec(filenamelength);

   PictureFileName:=filename;

   assign(f,'!!!.!!!');
   rewrite(f);
   write(f,PictureFileName);
   close(f);


   MouseCursor(ON);
end;

procedure Kernel;
var text_xpos:integer;
    exitcode:byte;

begin
   repeat

      { VESA16 KERNEL }
      if (videomode = VGA640x480x256)   or
         (videomode = VGA800x600x256)   or
         (videomode = VGA1024x768x256)   or
         (videomode = VESA800x600x16)   or        {VESA16.BGI modes}
         (videomode = VESA1024x768x16)  or
         (videomode = VESA1280x1024x16) then
      begin

         regs.ax:=$03;
         intr($33,regs);

         oldmousex:=round(regs.cx/8);  {because in VESA modes mouse jumps}
         oldmousey:=round(regs.dx/8);  {like in crt mode by 8 pixels}

         GetMouseBackground(oldmousex,oldmousey,BGI_GET_IMAGE);

         repeat
            regs.ax:=$03;
            intr($33,regs);

            newmousex:=round(regs.cx/8);   {because in VESA modes mouse jumps}
            newmousey:=round(regs.dx/8);   {like in crt mode by 8 pixels}

            if (newmousex <> oldmousex) or  {if mouse moved or clicked}
               (newmousey <> oldmousey) or  {or keyboard key pressed}
               (regs.bx = $01)          or
               keypressed               then
            begin
               PutMouseBackground(oldmousex,oldmousey,BGI_GET_IMAGE);
               if regs.bx = $01 then       {if clicked left button}
               begin
                  if (newmousey > 219)   and    {if clicked on menu}
                     (newmousey < 260)   and
                     (menustatus = ON)   then
                  begin
                     if (newmousex > 4) and (newmousex < 50) then
                     begin
                        Menu(newmousex,newmousey);
                        LoadPicture(cmdparam);
                        Menu(newmousex,newmousey);
                     end;

                     if (newmousex >= 50) and (newmousex < 99) then
                     begin
                        Menu(newmousex,newmousey);
                        SaveIRC;
                        Menu(newmousex,newmousey);
                     end;

                     if (newmousex >= 100) and (newmousex < 150) then
                     begin
                        Menu(newmousex,newmousey);
                        SaveNGF(PictureFileName);
                        Menu(newmousex,newmousey);
                     end;

                     if (newmousex >= 150) and (newmousex < 200) then
                     begin
                        Menu(newmousex,newmousey);
                        SaveFEC;
                        Menu(newmousex,newmousey);
                     end;

                     if (newmousex >= 250) and (newmousex < 300) then
                     paintmode:=PEN;

                     if (newmousex >= 300) and (newmousex < 350) then
                     paintmode:=WRITING;

                     if (newmousex >= 400) and (newmousex < 550) then
                     paintmode:=LINES;


                     if (newmousex >= (menuxpos+21))  and
                        (newmousex <= (menuxpos+276)) and
                        (newmousey >= (menuypos+40))  and
                        (newmousey <= (menuypos+60))  then
                     begin
                        MouseCursor(OFF);
                        color:=getpixel(newmousex,newmousey);
                        setcolor(color);
                        MouseCursor(ON);
                     end;

                  end
                  else

                  case paintmode of      {if clicked elsewhere menu}
                     PEN:begin
                            lineto(newmousex,newmousey);
                         end;

                     WRITING:begin
                                text_xpos:=newmousex;

                                repeat
                                   if keypressed then
                                   begin

                                      readchar:=readkey;
                                      if readchar <> ENTER then
                                      outtextxy(text_xpos,newmousey,readchar);

                                      text_xpos:=text_xpos+6;

                                   end;
                                until (readchar = ENTER);
                                readchar:=SPACE;
                             end;
                  end;{of case}
               end
               else
               begin
                  moveto(newmousex,newmousey);
               end;

               if keypressed then
               begin
                  key:=readkey;
                  if (key = SPACE) then
                  Menu(newmousex,newmousey);
                  if key = ESC then
                  exitcode:=1
               end;
               if regs.bx = $02 then
               Menu(newmousex,newmousey);

               if (newmousex > menuxpos)       and
                  (newmousex < menuxpos+300)   and
                  (newmousey > menuypos)       and    {if mouse is on menu}
                  (newmousey < menuypos+350)   and
                  (menustatus = ON)            then
               begin
                  GetMouseBackground(newmousex,newmousey,BGI_GET_IMAGE);
                  EmulateMCursor(newmousex,newmousey,ARROW,4);
                  oldmousex:=newmousex;
                  oldmousey:=newmousey;
               end
               else
               begin      {pen has active pixel down then newmousey-10}
                  GetMouseBackground(newmousex,newmousey-10,BGI_GET_IMAGE);
                  EmulateMCursor(newmousex,newmousey-10,PEN,4);
                  oldmousex:=newmousex;
                  oldmousey:=newmousey-10;
               end;
            end;



         until key = ESC;
      end;


      { VGA KERNEL }
      if videomode = VGA640x480x16 then
      begin
         repeat

            regs.ax:=$03;
            intr($33,regs);

            newmousex:=regs.cx;
            newmousey:=regs.dx;

            MouseCursor(ON);

            if regs.bx = $01 then
            begin
               if (newmousex > menuxpos)       and
                  (newmousex < (menuxpos+300)) and
                  (newmousey > menuypos)       and
                  (newmousey < (menuypos+350)) and
                  (menustatus = ON)            then
               begin
                  if (newmousex > (menuxpos+4))  and
                     (newmousex < (menuxpos+30)) and
                     (newmousey > (menuypos+18)) and
                     (newmousey < (menuypos+31)) then
                  begin
                     SaveMenu;
                     MouseCursor(OFF);
                     Menu(newmousex,newmousey);
                     SaveNGF(PictureFileName);
                     Menu(newmousex,newmousey);
                     MouseCursor(ON);
                  end;

                  if (newmousex > (menuxpos+50)) and
                     (newmousex < (menuxpos+80)) and
                     (newmousey > (menuypos+18)) and
                     (newmousey < (menuypos+31)) then
                  begin
                     MouseCursor(OFF);
                     Menu(newmousex,newmousey);
                     LoadPicture(cmdparam);
                     Menu(newmousex,newmousey);
                     MouseCursor(ON);
                  end;

                  if (newmousex >= (menuxpos+21))  and
                     (newmousex <= (menuxpos+276)) and
                     (newmousey >= (menuypos+40))  and
                     (newmousey <= (menuypos+60))  then
                  begin
                     MouseCursor(OFF);
                     color:=getpixel(newmousex,newmousey);
                     setcolor(color);
                     MouseCursor(ON);
                  end;

               end

               else

               case paintmode of
                  PEN:begin
                         MouseCursor(OFF);
                         lineto(newmousex,newmousey);
                         MouseCursor(ON);
                      end;

                  WRITING:begin
                             text_xpos:=newmousex;

                             repeat
                                if keypressed then
                                begin
                                   MouseCursor(OFF);

                                   readchar:=readkey;
                                   setcolor(color);
                                   if readchar <> ENTER then
                                   outtextxy(text_xpos,newmousey,readchar);

                                   text_xpos:=text_xpos+9;

                                   MouseCursor(ON);
                                end;
                             until (readchar = ENTER);
                          end;

               end;{of case}

            end

            else
            begin
               moveto(newmousex,newmousey);
            end;

            if regs.bx = $02 then
            begin
               MouseCursor(OFF);
               Menu(newmousex,newmousey);
               MouseCursor(ON);
            end;

            if (newmousex > menuxpos)     and
               (newmousex < menuxpos+300) and     { Menu width = 300 }
               (newmousey > menuypos)     and
               (newmousey < menuypos+350) and     { Menu height = 350 }
               (menustatus = ON) then
            SetMousePointer(ARROW)
            else
            SetMousePointer(PEN);

            if keypressed then
            begin
               readchar:=readkey;
               if readchar = ESC then
               exitcode:=1;
            end;

         until readchar = ESC;
      end;

   until exitcode = 1;

end;

begin

   videomode:=TEXT25x80;
   newvideomode:=VGA640x480x16;
   paintmode:=PEN;

   SetVideoMode(newvideomode);

   cmdparam:=paramstr(1);
   if cmdparam <> '' then
   LoadPicture(cmdparam)
   else
   cmdparam:='c:\temp\!sureal!.ngf';

   Kernel;

   SetVideoMode(TEXT25x80);

end.